<?php


include_once('config.php');

$home = home();

?><!doctype html>
<html lang="en-US">

<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<meta name='robots' content='index, follow, max-image-preview:large, max-snippet:-1, max-video-preview:-1' />

		<!-- Meta Tag Manager -->
		<meta name="keywords" content="<?php echo $home['title'];   ?>" />
		
		<!-- / Meta Tag Manager -->

	<!-- This site is optimized with the Yoast SEO plugin v23.1 - https://yoast.com/wordpress/plugins/seo/ -->
	<title> <?php echo $home['title'];   ?> – Explore Culture, Festivals & Delights</title>
	
	<meta name="description" content="<?php echo $short;    ?>" />
	
	
	
	<link rel="apple-touch-icon" sizes="180x180" href="images/favicon.ico">
    <link rel="icon" type="image/png" sizes="32x32" href="images/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="images/favicon-16x16.png">
    
	<meta property="og:title" content="<?php echo $city;    ?>" />
    <meta property="og:description" content="<?php echo $short; ?>." />
    <meta property="og:image" content="<?php echo $url; ?>ban-og.webp" />
    <meta property="og:url" content="<?php echo $url;   ?>" />
    
    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:site" content="@yourusername">
    <meta name="twitter:title" content="<?php echo $city;   ?>">
    <meta name="twitter:description" content="<?php echo $short;    ?>">
    <meta name="twitter:image" content="<?php echo $url;    ?>ban-og.webp">
	
	<?php
	
	/* to be editedd by db 
	<meta name="description" content="Explore Kedarnath darshan with us. Explore temples, travel tips, and experiences for an unforgettable pilgrimage." />
	<link rel="canonical" href="index.html" />
	<meta property="og:locale" content="en_US" />
	<meta property="og:type" content="website" />
	<meta property="og:title" content="KEDARNATH" />
	<meta property="og:description" content="This temple is dedicated to Lord Shiva and is believed to have been constructed by the Pandavas from the Mahabharata epic. It is one of the holiest shrines in Hinduism and attracts devotees from all over India." />
	<meta property="og:url" content="index.html" />
	<meta property="og:site_name" content="Kedarnath" />
	<meta property="article:modified_time" content="2024-08-29T10:52:09+00:00" />
	<meta property="og:image" content="wp-content/uploads/2024/08/image-_31_.html" />
	<meta property="og:image:width" content="1903" />
	<meta property="og:image:height" content="700" />
	<meta property="og:image:type" content="image/webp" />
	<meta name="twitter:card" content="summary_large_image" />
	<script type="application/ld+json" class="yoast-schema-graph">{"@context":"https://schema.org","@graph":[{"@type":"WebPage","@id":"https://kedarnathdarshan.net/","url":"https://kedarnathdarshan.net/","name":"Kedarnath Darshan | A Divine Journey","isPartOf":{"@id":"https://kedarnathdarshan.net/#website"},"primaryImageOfPage":{"@id":"https://kedarnathdarshan.net/#primaryimage"},"image":{"@id":"https://kedarnathdarshan.net/#primaryimage"},"thumbnailUrl":"https://kedarnathdarshan.net/wp-content/uploads/2024/07/pexels-alok-kumar-273007-15031440-2048x1365-1.webp","datePublished":"2023-04-10T06:36:52+00:00","dateModified":"2024-08-29T10:52:09+00:00","description":"Explore Kedarnath darshan with us. Explore temples, travel tips, and experiences for an unforgettable pilgrimage.","breadcrumb":{"@id":"https://kedarnathdarshan.net/#breadcrumb"},"inLanguage":"en-US","potentialAction":[{"@type":"ReadAction","target":["https://kedarnathdarshan.net/"]}]},{"@type":"ImageObject","inLanguage":"en-US","@id":"https://kedarnathdarshan.net/#primaryimage","url":"https://kedarnathdarshan.net/wp-content/uploads/2024/07/pexels-alok-kumar-273007-15031440-2048x1365-1.webp","contentUrl":"https://kedarnathdarshan.net/wp-content/uploads/2024/07/pexels-alok-kumar-273007-15031440-2048x1365-1.webp"},{"@type":"BreadcrumbList","@id":"https://kedarnathdarshan.net/#breadcrumb","itemListElement":[{"@type":"ListItem","position":1,"name":"Home"}]},{"@type":"WebSite","@id":"https://kedarnathdarshan.net/#website","url":"https://kedarnathdarshan.net/","name":"Kedarnath","description":"","potentialAction":[{"@type":"SearchAction","target":{"@type":"EntryPoint","urlTemplate":"https://kedarnathdarshan.net/?s={search_term_string}"},"query-input":"required name=search_term_string"}],"inLanguage":"en-US"}]}</script>
	*/
	?>
<style>
.elementskit-box-style-content {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

h3.elementskit-info-box-title {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

figcaption#gallery-1-1049 {
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}
    
    .widget ul li, .widget ol li {
        margin-bottom:0px !important;
        padding-bottom:0px !important;
    }
    .widget h2 {
        margin-bottom:5px !important;
    }
    .footer-widget-wrap {
        padding-top:15px;
        padding-bottom:15px;
    }
    .e-con {
        margin:auto;
    }
    @media only screen and (max-width: 768px) {
        .ads {
            width:314px;height:150px;border:1px solid black; background-color:grey;padding:5px;margin:auto;
        }
        .e-con {
            --container-max-width:100% !important;
        }
    }
    @media only screen and (min-width: 769px) and (max-width: 1400px) {
        .e-con {
            --container-max-width:70% !important;
        }
    }
    
    @media only screen and (min-width: 1400px) {
        .e-con {
            --container-max-width:1140px !important;
        }
    }
    
    @media only screen and (min-width: 768px) {
        .ads {
            width:565px;height:150px;border:1px solid black; background-color:grey;padding:50px;margin:auto;
        }
    }
    
    .panel-box {
        margin-top:10px;
    }
    .gallery-caption {
        background-color:<?php echo $bgcolor;   ?> !important;
    }
    
    .elementskit-btn {
        background-color:<?php echo $bgcolor;   ?> !important;
    }

    .elementor-92 .elementor-element.elementor-element-0e93115:not(.elementor-motion-effects-element-type-background), .elementor-92 .elementor-element.elementor-element-0e93115>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* homepage */ echo $burl;  ?>) !important;
    }
    ..elementor-88 .elementor-element.elementor-element-b4b11a9:not(.elementor-motion-effects-element-type-background), .elementor-88 .elementor-element.elementor-element-b4b11a9>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* about us */ echo $burl;  ?>);
    }
    .elementor-84 .elementor-element.elementor-element-f08ba9b:not(.elementor-motion-effects-element-type-background), .elementor-84 .elementor-element.elementor-element-f08ba9b>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* Destinations */ echo $burl;  ?>);
    }
    
    .elementor-422 .elementor-element.elementor-element-20b8fcc:not(.elementor-motion-effects-element-type-background), .elementor-422 .elementor-element.elementor-element-20b8fcc>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* Tourist Service */ echo $burl;  ?>);
    }
    .elementor-184 .elementor-element.elementor-element-bc70056:not(.elementor-motion-effects-element-type-background), .elementor-184 .elementor-element.elementor-element-bc70056>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* Gallery */ echo $burl;  ?>);
    }
    .elementor-80 .elementor-element.elementor-element-be83bec:not(.elementor-motion-effects-element-type-background), .elementor-80 .elementor-element.elementor-element-be83bec>.elementor-motion-effects-container>.elementor-motion-effects-layer {
        background-image: url(<?php /* Contact us */ echo $burl;  ?>);
    }
    
    <?php
    
    echo $css;
    
    ?>
    
    
</style>



<style>
.accordion {
  background-color: #eee;
  color: #444;
  cursor: pointer;
  padding: 18px;
  width: 100%;
  border: none;
  text-align: left;
  outline: none;
  font-size: 15px;
  transition: 0.4s;
}

.active, .accordion:hover {
  background-color: #ccc;
}

.accordion:after {
  content: '\002B';
  color: #777;
  font-weight: bold;
  float: right;
  margin-left: 5px;
}

.active:after {
  content: "\2212";
}

.panel {
  padding: 0 18px;
  background-color: white;
  max-height: 0;
  overflow: hidden;
  transition: max-height 0.2s ease-out;
}
</style>




<link rel='dns-prefetch' href='http://fonts.googleapis.com/' />

<style id='classic-theme-styles-inline-css' type='text/css'>
/*! This file is auto-generated */
.wp-block-button__link{color:#fff;background-color:#32373c;border-radius:9999px;box-shadow:none;text-decoration:none;padding:calc(.667em + 2px) calc(1.333em + 2px);font-size:1.125em}.wp-block-file__button{background:#32373c;color:#fff;text-decoration:none}
</style>
<style id='global-styles-inline-css' type='text/css'>
:root{--wp--preset--aspect-ratio--square: 1;--wp--preset--aspect-ratio--4-3: 4/3;--wp--preset--aspect-ratio--3-4: 3/4;--wp--preset--aspect-ratio--3-2: 3/2;--wp--preset--aspect-ratio--2-3: 2/3;--wp--preset--aspect-ratio--16-9: 16/9;--wp--preset--aspect-ratio--9-16: 9/16;--wp--preset--color--black: #000000;--wp--preset--color--cyan-bluish-gray: #abb8c3;--wp--preset--color--white: #ffffff;--wp--preset--color--pale-pink: #f78da7;--wp--preset--color--vivid-red: #cf2e2e;--wp--preset--color--luminous-vivid-orange: #ff6900;--wp--preset--color--luminous-vivid-amber: #fcb900;--wp--preset--color--light-green-cyan: #7bdcb5;--wp--preset--color--vivid-green-cyan: #00d084;--wp--preset--color--pale-cyan-blue: #8ed1fc;--wp--preset--color--vivid-cyan-blue: #0693e3;--wp--preset--color--vivid-purple: #9b51e0;--wp--preset--color--tan: #D2B48C;--wp--preset--color--yellow: #FDE64B;--wp--preset--color--orange: #ED7014;--wp--preset--color--red: #D0312D;--wp--preset--color--pink: #b565a7;--wp--preset--color--purple: #A32CC4;--wp--preset--color--blue: #4E97D8;--wp--preset--color--green: #00B294;--wp--preset--color--brown: #231709;--wp--preset--color--grey: #7D7D7D;--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple: linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%);--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan: linear-gradient(135deg,rgb(122,220,180) 0%,rgb(0,208,130) 100%);--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange: linear-gradient(135deg,rgba(252,185,0,1) 0%,rgba(255,105,0,1) 100%);--wp--preset--gradient--luminous-vivid-orange-to-vivid-red: linear-gradient(135deg,rgba(255,105,0,1) 0%,rgb(207,46,46) 100%);--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray: linear-gradient(135deg,rgb(238,238,238) 0%,rgb(169,184,195) 100%);--wp--preset--gradient--cool-to-warm-spectrum: linear-gradient(135deg,rgb(74,234,220) 0%,rgb(151,120,209) 20%,rgb(207,42,186) 40%,rgb(238,44,130) 60%,rgb(251,105,98) 80%,rgb(254,248,76) 100%);--wp--preset--gradient--blush-light-purple: linear-gradient(135deg,rgb(255,206,236) 0%,rgb(152,150,240) 100%);--wp--preset--gradient--blush-bordeaux: linear-gradient(135deg,rgb(254,205,165) 0%,rgb(254,45,45) 50%,rgb(107,0,62) 100%);--wp--preset--gradient--luminous-dusk: linear-gradient(135deg,rgb(255,203,112) 0%,rgb(199,81,192) 50%,rgb(65,88,208) 100%);--wp--preset--gradient--pale-ocean: linear-gradient(135deg,rgb(255,245,203) 0%,rgb(182,227,212) 50%,rgb(51,167,181) 100%);--wp--preset--gradient--electric-grass: linear-gradient(135deg,rgb(202,248,128) 0%,rgb(113,206,126) 100%);--wp--preset--gradient--midnight: linear-gradient(135deg,rgb(2,3,129) 0%,rgb(40,116,252) 100%);--wp--preset--font-size--small: 12px;--wp--preset--font-size--medium: 20px;--wp--preset--font-size--large: 36px;--wp--preset--font-size--x-large: 42px;--wp--preset--font-size--regular: 16px;--wp--preset--font-size--larger: 36px;--wp--preset--font-size--huge: 48px;--wp--preset--spacing--20: 0.44rem;--wp--preset--spacing--30: 0.67rem;--wp--preset--spacing--40: 1rem;--wp--preset--spacing--50: 1.5rem;--wp--preset--spacing--60: 2.25rem;--wp--preset--spacing--70: 3.38rem;--wp--preset--spacing--80: 5.06rem;--wp--preset--shadow--natural: 6px 6px 9px rgba(0, 0, 0, 0.2);--wp--preset--shadow--deep: 12px 12px 50px rgba(0, 0, 0, 0.4);--wp--preset--shadow--sharp: 6px 6px 0px rgba(0, 0, 0, 0.2);--wp--preset--shadow--outlined: 6px 6px 0px -3px rgba(255, 255, 255, 1), 6px 6px rgba(0, 0, 0, 1);--wp--preset--shadow--crisp: 6px 6px 0px rgba(0, 0, 0, 1);}:where(.is-layout-flex){gap: 0.5em;}:where(.is-layout-grid){gap: 0.5em;}body .is-layout-flex{display: flex;}.is-layout-flex{flex-wrap: wrap;align-items: center;}.is-layout-flex > :is(*, div){margin: 0;}body .is-layout-grid{display: grid;}.is-layout-grid > :is(*, div){margin: 0;}:where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}:where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}.has-black-color{color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-color{color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-color{color: var(--wp--preset--color--white) !important;}.has-pale-pink-color{color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-color{color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-color{color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-color{color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-color{color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-color{color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-color{color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-color{color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-color{color: var(--wp--preset--color--vivid-purple) !important;}.has-black-background-color{background-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-background-color{background-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-background-color{background-color: var(--wp--preset--color--white) !important;}.has-pale-pink-background-color{background-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-background-color{background-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-background-color{background-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-background-color{background-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-background-color{background-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-background-color{background-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-background-color{background-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-background-color{background-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-background-color{background-color: var(--wp--preset--color--vivid-purple) !important;}.has-black-border-color{border-color: var(--wp--preset--color--black) !important;}.has-cyan-bluish-gray-border-color{border-color: var(--wp--preset--color--cyan-bluish-gray) !important;}.has-white-border-color{border-color: var(--wp--preset--color--white) !important;}.has-pale-pink-border-color{border-color: var(--wp--preset--color--pale-pink) !important;}.has-vivid-red-border-color{border-color: var(--wp--preset--color--vivid-red) !important;}.has-luminous-vivid-orange-border-color{border-color: var(--wp--preset--color--luminous-vivid-orange) !important;}.has-luminous-vivid-amber-border-color{border-color: var(--wp--preset--color--luminous-vivid-amber) !important;}.has-light-green-cyan-border-color{border-color: var(--wp--preset--color--light-green-cyan) !important;}.has-vivid-green-cyan-border-color{border-color: var(--wp--preset--color--vivid-green-cyan) !important;}.has-pale-cyan-blue-border-color{border-color: var(--wp--preset--color--pale-cyan-blue) !important;}.has-vivid-cyan-blue-border-color{border-color: var(--wp--preset--color--vivid-cyan-blue) !important;}.has-vivid-purple-border-color{border-color: var(--wp--preset--color--vivid-purple) !important;}.has-vivid-cyan-blue-to-vivid-purple-gradient-background{background: var(--wp--preset--gradient--vivid-cyan-blue-to-vivid-purple) !important;}.has-light-green-cyan-to-vivid-green-cyan-gradient-background{background: var(--wp--preset--gradient--light-green-cyan-to-vivid-green-cyan) !important;}.has-luminous-vivid-amber-to-luminous-vivid-orange-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-amber-to-luminous-vivid-orange) !important;}.has-luminous-vivid-orange-to-vivid-red-gradient-background{background: var(--wp--preset--gradient--luminous-vivid-orange-to-vivid-red) !important;}.has-very-light-gray-to-cyan-bluish-gray-gradient-background{background: var(--wp--preset--gradient--very-light-gray-to-cyan-bluish-gray) !important;}.has-cool-to-warm-spectrum-gradient-background{background: var(--wp--preset--gradient--cool-to-warm-spectrum) !important;}.has-blush-light-purple-gradient-background{background: var(--wp--preset--gradient--blush-light-purple) !important;}.has-blush-bordeaux-gradient-background{background: var(--wp--preset--gradient--blush-bordeaux) !important;}.has-luminous-dusk-gradient-background{background: var(--wp--preset--gradient--luminous-dusk) !important;}.has-pale-ocean-gradient-background{background: var(--wp--preset--gradient--pale-ocean) !important;}.has-electric-grass-gradient-background{background: var(--wp--preset--gradient--electric-grass) !important;}.has-midnight-gradient-background{background: var(--wp--preset--gradient--midnight) !important;}.has-small-font-size{font-size: var(--wp--preset--font-size--small) !important;}.has-medium-font-size{font-size: var(--wp--preset--font-size--medium) !important;}.has-large-font-size{font-size: var(--wp--preset--font-size--large) !important;}.has-x-large-font-size{font-size: var(--wp--preset--font-size--x-large) !important;}
:where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}
:where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}
:root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}
</style>
<link rel='stylesheet' id='wpo_min-header-0-css' href='wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-header-edaa8b75.min.css' type='text/css' media='all' />
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin><script type="text/javascript" src="wp-includes/js/jquery/jquery.min.js" id="jquery-core-js"></script>
<script type="text/javascript" src="wp-includes/js/jquery/jquery-migrate.min.js" id="jquery-migrate-js"></script>
<link rel="https://api.w.org/" href="wp-json/index.html" /><link rel="alternate" title="JSON" type="application/json" href="wp-json/wp/v2/pages/92.json" /><link rel="EditURI" type="application/rsd+xml" title="RSD" href="xmlrpc0db0.php?rsd" />
<meta name="generator" content="WordPress 6.6.1" />
<link rel='shortlink' href='index.html' />
<link rel="alternate" title="oEmbed (JSON)" type="application/json+oembed" href="wp-json/oembed/1.0/embed0c52.json?url=https%3A%2F%2Fkedarnathdarshan.net%2F" />
<link rel="alternate" title="oEmbed (XML)" type="text/xml+oembed" href="wp-json/oembed/1.0/embed0d78?url=https%3A%2F%2Fkedarnathdarshan.net%2F&amp;format=xml" />



<div class="verification" data-mid="MON-250356084780"></div>
		<style>.site-header .site-branding > a {max-width: 270px;overflow: hidden;display: inline-block;}/* Site Title */.header-one .site-branding .site-title, .header-two .site-branding .site-title, .header-three .site-branding .site-title {color: #ffffff;}/* Tagline */.header-one .site-branding .site-description,.header-two .site-branding .site-description,.header-three .site-branding .site-description {color: #767676;}/* Site general link color */a {color: #a6a6a6;}/* Page and Single Post Title */body.single .page-title, body.page .page-title {color: #101010;}/* Site body Text */body, html {color: #333333;}/* Heading Text */h1, h2, h3, h4, h5, h6, .product-title {color: #030303;}/* Primary Background */.section-title:before, .button-primary, .woocommerce span.onsale, body .woocommerce.widget_price_filter .ui-slider .ui-slider-handle, #offcanvas-menu .header-btn-wrap .header-btn .button-primary {background-color: #5733ff;}/* Primary Border */.post .entry-content .entry-header .cat-links a, .attachment .entry-content .entry-header .cat-links a, .wrap-coming-maintenance-mode .content .button-container .button-primary {border-color: #5733ff;}/* Primary Color */ blockquote:before, .post .entry-content .entry-header .cat-links a, .attachment .entry-content .entry-header .cat-links a, .post .entry-meta a:before, .attachment .entry-meta a:before, .single .entry-container .cat-links:before, .post .entry-meta .tag-links:before {color: #5733ff;}/* Hover Background */input[type=button]:hover, input[type=button]:active, input[type=button]:focus, input[type=reset]:hover, input[type=reset]:active, input[type=reset]:focus, input[type=submit]:hover, input[type=submit]:active, input[type=submit]:focus, .button-primary:hover, .button-primary:focus, .button-primary:active, .button-outline:hover, .button-outline:focus, .button-outline:active, .search-form .search-button:hover, .search-form .search-button:focus, .search-form .search-button:active, .page-numbers .page-numbers:hover, .page-numbers .page-numbers:focus, .page-numbers .page-numbers:active, .nav-links .page-numbers:hover, .nav-links .page-numbers:focus, .nav-links .page-numbers:active, #back-to-top a:hover, #back-to-top a:focus, #back-to-top a:active, .section-highlight-post .slick-control li.slick-arrow:not(.slick-disabled):hover, .section-highlight-post .slick-control li.slick-arrow:not(.slick-disabled):focus, .section-highlight-post .slick-control li.slick-arrow:not(.slick-disabled):active, .alt-menu-icon a:hover .icon-bar, .alt-menu-icon a:focus .icon-bar, .alt-menu-icon a:active .icon-bar, .alt-menu-icon a:hover .icon-bar:before, .alt-menu-icon a:hover .icon-bar:after, .alt-menu-icon a:focus .icon-bar:before, .alt-menu-icon a:focus .icon-bar:after, .alt-menu-icon a:active .icon-bar:before, .alt-menu-icon a:active .icon-bar:after, #offcanvas-menu .close-offcanvas-menu button:hover,#offcanvas-menu .close-offcanvas-menu button:active, .highlight-post-slider .post .entry-meta .cat-links a:hover, .highlight-post-slider .post .entry-meta .cat-links a:focus, .highlight-post-slider .post .entry-meta .cat-links a:active, .site-footer .social-profile ul li a:hover, .site-footer .social-profile ul li a:focus, .site-footer .social-profile ul li a:active, #back-to-top a:hover, #back-to-top a:focus, #back-to-top a:active, .comments-area .comment-list .reply a:hover, .comments-area .comment-list .reply a:focus, .comments-area .comment-list .reply a:active, .widget .tagcloud a:hover, .widget .tagcloud a:focus, .widget .tagcloud a:active, .infinite-scroll #infinite-handle span:hover, .infinite-scroll #infinite-handle span:focus, .infinite-scroll #infinite-handle span:active, .slicknav_btn:hover .slicknav_icon-bar, .slicknav_btn:focus .slicknav_icon-bar, .slicknav_btn:hover .slicknav_icon-bar, .slicknav_btn:hover .slicknav_icon-bar:first-child:before, .slicknav_btn:hover .slicknav_icon-bar:first-child:after, .slicknav_btn:focus .slicknav_icon-bar:first-child:before, .slicknav_btn:focus .slicknav_icon-bar:first-child:after, .slicknav_btn:hover .slicknav_icon-bar:first-child:before, .slicknav_btn:hover .slicknav_icon-bar:first-child:after, .woocommerce #respond input#submit:hover, .woocommerce #respond input#submit:focus, .woocommerce #respond input#submit:active, .woocommerce #respond input#submit:hover, .woocommerce #respond input#submit:focus, .woocommerce #respond input#submit:active, .woocommerce a.button:hover, .woocommerce a.button:focus, .woocommerce a.button:active, .woocommerce button.button:hover, .woocommerce button.button:focus, .woocommerce button.button:active, .woocommerce input.button:hover, .woocommerce input.button:focus, .woocommerce input.button:active, .woocommerce a.button.alt:hover, .woocommerce a.button.alt:focus, .woocommerce a.button.alt:active, .woocommerce button.button.alt:hover, .woocommerce button.button.alt:focus, .woocommerce button.button.alt:active, .woocommerce a.button:hover, .woocommerce a.button:focus, .widget.widget_product_search [type=submit]:hover, .widget.widget_product_search [type=submit]:focus, .widget.widget_product_search [type=submit]:active, #offcanvas-menu .header-btn-wrap .header-btn .button-primary:hover, #offcanvas-menu .header-btn-wrap .header-btn .button-primary:focus, #offcanvas-menu .header-btn-wrap .header-btn .button-primary:active, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:hover, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:focus, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:active, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current {background-color: #5733ff;}/* Hover Border */.button-outline:hover, .button-outline:focus, .button-outline:active, #offcanvas-menu .close-offcanvas-menu button:hover, #offcanvas-menu .close-offcanvas-menu button:active, .page-numbers .page-numbers:hover, .page-numbers .page-numbers:focus, .page-numbers .page-numbers:active, .nav-links .page-numbers:hover, .nav-links .page-numbers:focus, .nav-links .page-numbers:active, #back-to-top a:hover, #back-to-top a:focus, #back-to-top a:active, .post .entry-content .entry-header .cat-links a:hover, .post .entry-content .entry-header .cat-links a:focus, .post .entry-content .entry-header .cat-links a:active, .attachment .entry-content .entry-header .cat-links a:hover, .attachment .entry-content .entry-header .cat-links a:focus, .attachment .entry-content .entry-header .cat-links a:active, .banner-content .entry-content .entry-header .cat-links a:hover, .banner-content .entry-content .entry-header .cat-links a:focus, .banner-content .entry-content .entry-header .cat-links a:active, .slick-control li:not(.slick-disabled):hover span, .slick-control li:not(.slick-disabled):focus span, .slick-control li:not(.slick-disabled):active span, .section-banner .banner-content .button-container .button-outline:hover, .section-banner .banner-content .button-container .button-outline:focus, .section-banner .banner-content .button-container .button-outline:active, #back-to-top a:hover, #back-to-top a:focus, #back-to-top a:active, .widget .tagcloud a:hover, .widget .tagcloud a:focus, .widget .tagcloud a:active, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:hover, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:focus, #offcanvas-menu .header-btn-wrap .header-btn .button-outline:active, .wrap-coming-maintenance-mode .content .social-profile ul a:hover, .wrap-coming-maintenance-mode .content .social-profile ul a:focus, .wrap-coming-maintenance-mode .content .social-profile ul a:active, .summary .yith-wcwl-add-button a:hover, .woocommerce .entry-summary a.compare.button:hover, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current,.summary .yith-wcwl-add-to-wishlist a:hover i, .summary .yith-wcwl-add-to-wishlist a:focus i {border-color: #5733ff;}/* Hover Text */a:hover, a:focus, a:active, .main-navigation ul.menu ul li a:hover, .main-navigation ul.menu ul li a:focus, .main-navigation ul.menu ul li a:active, .main-navigation ul.menu > li:hover > a, .main-navigation ul.menu > li:focus > a, .main-navigation ul.menu > li:active > a, .main-navigation ul.menu > li.focus > a, .main-navigation ul.menu li.current-menu-item > a, .main-navigation ul.menu li.current_page_item > a, .main-navigation ul.menu li.current-menu-parent > a, .comment-navigation .nav-previous a:hover, .comment-navigation .nav-previous a:focus, .comment-navigation .nav-previous a:active, .comment-navigation .nav-next a:hover, .comment-navigation .nav-next a:focus, .comment-navigation .nav-next a:active, .posts-navigation .nav-previous a:hover, .posts-navigation .nav-previous a:focus, .posts-navigation .nav-previous a:active, .posts-navigation .nav-next a:hover, .posts-navigation .nav-next a:focus, .posts-navigation .nav-next a:active, .post-navigation .nav-previous a:hover, .post-navigation .nav-previous a:focus, .post-navigation .nav-previous a:active, .post-navigation .nav-next a:hover, .post-navigation .nav-next a:focus, .post-navigation .nav-next a:active, .social-profile ul li a:hover, .social-profile ul li a:focus, .social-profile ul li a:active, .post .entry-content .entry-header .cat-links a:hover, .post .entry-content .entry-header .cat-links a:focus, .post .entry-content .entry-header .cat-links a:active, .attachment .entry-content .entry-header .cat-links a:hover, .attachment .entry-content .entry-header .cat-links a:focus, .attachment .entry-content .entry-header .cat-links a:active, .banner-content .entry-content .entry-header .cat-links a:hover, .banner-content .entry-content .entry-header .cat-links a:focus, .banner-content .entry-content .entry-header .cat-links a:active, .post .entry-meta a:hover, .post .entry-meta a:focus, .post .entry-meta a:active, .attachment .entry-meta a:hover, .attachment .entry-meta a:focus, .attachment .entry-meta a:active, .banner-content .entry-meta a:hover, .banner-content .entry-meta a:focus, .banner-content .entry-meta a:active, .post .entry-meta a:hover:before, .post .entry-meta a:focus:before, .post .entry-meta a:active:before, .attachment .entry-meta a:hover:before, .attachment .entry-meta a:focus:before, .attachment .entry-meta a:active:before, .banner-content .entry-meta a:hover:before, .banner-content .entry-meta a:focus:before, .banner-content .entry-meta a:active:before, .breadcrumb-wrap .breadcrumbs .trail-items a:hover, .breadcrumb-wrap .breadcrumbs .trail-items a:focus, .breadcrumb-wrap .breadcrumbs .trail-items a:active, .site-header .site-branding .site-title a:hover, .site-header .site-branding .site-title a:focus, .site-header .site-branding .site-title a:active, .header-icons .search-icon:hover, .header-icons .search-icon:focus, .header-icons .search-icon:active, .header-search .search-form .search-button:hover, .header-search .close-button:hover, .header-contact ul a:hover, .header-contact ul a:focus, .header-contact ul a:active, .section-banner .banner-content .entry-meta a:hover, .section-banner .banner-content .entry-meta a:focus, .section-banner .banner-content .entry-meta a:active, .site-footer .site-info a:hover, .site-footer .site-info a:focus, .site-footer .site-info a:active, .site-footer .footer-menu ul li a:hover, .site-footer .footer-menu ul li a:focus, .site-footer .footer-menu ul li a:active, .comments-area .comment-list .comment-metadata a:hover, .comments-area .comment-list .comment-metadata a:focus, .comments-area .comment-list .comment-metadata a:active, .widget ul li a:hover, .widget ul li a:focus, .widget ul li a:active, .woocommerce .product_meta .posted_in a:hover, .woocommerce .product_meta .posted_in a:focus, .woocommerce .product_meta .posted_in a:active, .woocommerce .product_meta .tagged_as a:hover, .woocommerce .product_meta .tagged_as a:focus, .woocommerce .product_meta .tagged_as a:active, .woocommerce .woocommerce-MyAccount-navigation ul li a:hover, .woocommerce .woocommerce-MyAccount-navigation ul li a:focus, .woocommerce .woocommerce-MyAccount-navigation ul li a:active, .woocommerce .woocommerce-MyAccount-content p a:hover, .woocommerce .woocommerce-MyAccount-content p a:focus, .woocommerce .woocommerce-MyAccount-content p a:active, .product .product-compare-wishlist .product-compare a:hover, .product .product-compare-wishlist .product-wishlist a:hover, .section-banner .banner-content .button-container .button-text:hover, .section-banner .banner-content .button-container .button-text:focus, .section-banner .banner-content .button-container .button-text:active, .social-profile ul li a:hover, .wrap-coming-maintenance-mode .content .header-contact ul a:hover, .wrap-coming-maintenance-mode .content .header-contact ul a:focus, .wrap-coming-maintenance-mode .content .header-contact ul a:active, #offcanvas-menu .header-navigation ul.menu > li a:hover, #offcanvas-menu .header-navigation ul.menu > li a:focus, #offcanvas-menu .header-navigation ul.menu > li a:active, #offcanvas-menu .social-profile ul li a:hover, #offcanvas-menu .social-profile ul li a:focus, #offcanvas-menu .social-profile ul li a:active, #offcanvas-menu .header-contact ul li a:hover, #offcanvas-menu .header-contact ul li a:focus, #offcanvas-menu .header-contact ul li a:active, #offcanvas-menu .header-btn-wrap .header-btn .button-text:hover, #offcanvas-menu .header-btn-wrap .header-btn .button-text:focus, #offcanvas-menu .header-btn-wrap .header-btn .button-text:active, .wrap-coming-maintenance-mode .content .social-profile ul a:hover, .wrap-coming-maintenance-mode .content .social-profile ul a:focus, .wrap-coming-maintenance-mode .content .social-profile ul a:active,.woocommerce .woocommerce-MyAccount-navigation ul li.is-active a, .woocommerce ul.products li.product .woocommerce-loop-product__title:hover, .woocommerce ul.products li.product .woocommerce-loop-product__title:focus, .woocommerce ul.products li.product .woocommerce-loop-product__title:active, .widget.widget_recently_viewed_products li .product-title:hover, .widget.widget_recently_viewed_products li .product-title:active, .widget.widget_recent_reviews li .product-title:hover, .widget.widget_recent_reviews li .product-title:active, .widget.widget_products .product_list_widget li .product-title:hover, .widget.widget_products .product_list_widget li .product-title:active, .summary .yith-wcwl-add-button a:hover, .woocommerce .entry-summary a.compare.button:hover, .summary .yith-wcwl-add-to-wishlist a:hover i, .summary .yith-wcwl-add-to-wishlist a:focus i {color: #5733ff;}/* Feature Posts*/.feature-posts-layout-one .feature-posts-content-wrap .feature-posts-image:before { background-color: rgba(0, 0, 0, 0.4);}.header-one .top-header,body:not(.home) .header-two .top-header,.header-three .top-header {background-color: #ffffff;}.header-one .header-contact ul li, .header-one .header-contact ul li a, .header-one .social-profile ul li a,.header-one .header-icons .search-icon,.header-two .header-contact ul li, .header-two .header-contact ul li a, .header-two .social-profile ul li a,.header-two .header-icons .search-icon,.header-three .header-navigation ul.menu > li > a, .header-three .alt-menu-icon .iconbar-label, .header-three .social-profile ul li a {color: #ffffff;}@media only screen and (max-width: 991px) {.alt-menu-icon .iconbar-label {color: #ffffff;}header.site-header .alt-menu-icon .icon-bar, header.site-header .alt-menu-icon .icon-bar:before, header.site-header .alt-menu-icon .icon-bar:after {background-color: #ffffff;}.alt-menu-icon a:hover .iconbar-label,.alt-menu-icon a:focus .iconbar-label,.alt-menu-icon a:active .iconbar-label {color: #ffffff;}header.site-header .alt-menu-icon a:hover .icon-bar, header.site-header .alt-menu-icon a:focus .icon-bar, header.site-header .alt-menu-icon a:active .icon-bar, header.site-header .alt-menu-icon a:hover .icon-bar:before, header.site-header .alt-menu-icon a:focus .icon-bar:before, header.site-header .alt-menu-icon a:active .icon-bar:before, header.site-header .alt-menu-icon a:hover .icon-bar:after,header.site-header .alt-menu-icon a:focus .icon-bar:after,header.site-header .alt-menu-icon a:active .icon-bar:after {background-color: #ffffff;}}.header-one .alt-menu-icon .icon-bar, .header-one .alt-menu-icon .icon-bar:before, .header-one .alt-menu-icon .icon-bar:after,.header-two .alt-menu-icon .icon-bar, .header-two .alt-menu-icon .icon-bar:before, .header-two .alt-menu-icon .icon-bar:after {background-color: #ffffff;}.header-one .header-contact ul li a:hover, .header-one .header-contact ul li a:focus, .header-one .header-contact ul li a:active, .header-one .social-profile ul li a:hover, .header-one .social-profile ul li a:focus, .header-one .social-profile ul li a:active,.header-one .header-search-wrap .search-icon:hover,.header-one .header-search-wrap .search-icon:focus,.header-one .header-search-wrap .search-icon:active,.header-two .header-contact ul li a:hover, .header-two .header-contact ul li a:focus, .header-two .header-contact ul li a:active, .header-two .social-profile ul li a:hover,.header-two .social-profile ul li a:focus,.header-two .social-profile ul li a:active,.header-two .header-icons .search-icon:hover,.header-two .header-icons .search-icon:focus,.header-two .header-icons .search-icon:active,.header-three .header-navigation ul.menu > li > a:hover, .header-three .header-navigation ul.menu > li > a:focus, .header-three .header-navigation ul.menu > li > a:active, .header-three .social-profile ul li a:hover, .header-three .social-profile ul li a:focus, .header-three .social-profile ul li a:active {color: #ffffff;}.header-one .alt-menu-icon a:hover .icon-bar, .header-one .alt-menu-icon a:focus .icon-bar, .header-one .alt-menu-icon a:active .icon-bar, .header-one .alt-menu-icon a:hover .icon-bar:before, .header-one .alt-menu-icon a:focus .icon-bar:before, .header-one .alt-menu-icon a:active .icon-bar:before, .header-one .alt-menu-icon a:hover .icon-bar:after,.header-one .alt-menu-icon a:focus .icon-bar:after,.header-one .alt-menu-icon a:active .icon-bar:after,.header-two .alt-menu-icon a:hover .icon-bar, .header-two .alt-menu-icon a:focus .icon-bar, .header-two .alt-menu-icon a:active .icon-bar, .header-two .alt-menu-icon a:hover .icon-bar:before, .header-two .alt-menu-icon a:focus .icon-bar:before, .header-two .alt-menu-icon a:active .icon-bar:before, .header-two .alt-menu-icon a:hover .icon-bar:after,.header-two .alt-menu-icon a:focus .icon-bar:after,.header-two .alt-menu-icon a:active .icon-bar:after,.home .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar, .home .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar, .home .header-two:not(.sticky-header) .alt-menu-icon a:active .icon-bar, .home .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar:before, .home .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar:before, .home .header-two:not(.sticky-header) .alt-menu-icon a:active .icon-bar:before, .home .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar:after,.home .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar:after,.home .header-two:not(.sticky-header) .alt-menu-icon a:active .icon-bar:after {background-color: #ffffff;}.mid-header .overlay {background-color: ;}.header-three .site-branding .site-title a:hover,.header-three .site-branding .site-title a:focus,.header-three .site-branding .site-title a:active {color: #086abd;}.header-one .bottom-header .overlay,body:not(.home) .header-two .bottom-header .overlay,.header-three .bottom-header,.header-three .mobile-menu-container {background-color: ;}@media only screen and (max-width: 991px) {.header-one .mobile-menu-container {background-color: ;}}.header-one .main-navigation ul.menu > li > a,.header-two .main-navigation ul.menu > li > a,.header-three .main-navigation ul.menu > li > a, .header-three .header-icons .search-icon {color: #ffffff;}.site-header .slicknav_btn:not(.slicknav_open) .slicknav_icon span,.site-header .slicknav_btn:not(.slicknav_open) .slicknav_icon span:first-child:before, .site-header .slicknav_btn:not(.slicknav_open) .slicknav_icon span:first-child:after {background-color: #ffffff;}.header-one .site-branding .site-title a:hover,.header-one .site-branding .site-title a:focus,.header-one .site-branding .site-title a:active,.header-one .main-navigation ul.menu li a:hover, .header-one .main-navigation ul.menu li a:focus, .header-one .main-navigation ul.menu li a:active, .header-one .main-navigation ul.menu li.current-menu-item > a,.header-one .main-navigation ul.menu li.current_page_item > a,.header-one .main-navigation ul.menu > li:hover > a, .header-one .main-navigation ul.menu > li:focus > a, .header-one .main-navigation ul.menu > li:active > a, .header-two .site-branding .site-title a:hover,.header-two .site-branding .site-title a:focus,.header-two .site-branding .site-title a:active,.header-two .header-search-wrap .search-icon:hover,.header-two .header-search-wrap .search-icon:focus,.header-two .header-search-wrap .search-icon:active,.header-two .main-navigation ul.menu li a:hover, .header-two .main-navigation ul.menu li a:focus, .header-two .main-navigation ul.menu > li > a:active, .header-two .main-navigation ul.menu li.current-menu-item > a,.header-two .main-navigation ul.menu li.current_page_item > a,.header-two .main-navigation ul.menu > li:hover > a, .header-two .main-navigation ul.menu > li:focus > a, .header-two .main-navigation ul.menu > li:active > a, .header-two .header-icons .search-icon:hover, .header-two .header-icons .search-icon:focus, .header-two .header-icons .search-icon:active, .home .header-two:not(.sticky-header) .main-navigation ul.menu li a:hover, .home .header-two:not(.sticky-header) .main-navigation ul.menu li a:focus, .home .header-two:not(.sticky-header) .main-navigation ul.menu li a:active,.header-three .main-navigation ul.menu > li > a:hover, .header-three .main-navigation ul.menu > li > a:focus, .header-three .main-navigation ul.menu > li > a:active, .header-three .main-navigation ul.menu li.current-menu-item > a,.header-three .main-navigation ul.menu li.current_page_item > a,.header-three .main-navigation ul.menu > li:hover > a, .header-three .main-navigation ul.menu > li:focus > a, .header-three .main-navigation ul.menu > li:active > a, .header-three .header-icons .search-icon:hover, .header-three .header-icons .search-icon:focus, .header-three .header-icons .search-icon:active {color: #000000;}.header-three .alt-menu-icon .icon-bar, .header-three .alt-menu-icon .icon-bar:before, .header-three .alt-menu-icon .icon-bar:after {background-color: #ffffff;}.header-three .alt-menu-icon a:hover .icon-bar, .header-three .alt-menu-icon a:focus .icon-bar, .header-three .alt-menu-icon a:active .icon-bar, .header-three .alt-menu-icon a:hover .icon-bar:before, .header-three .alt-menu-icon a:focus .icon-bar:before, .header-three .alt-menu-icon a:active .icon-bar:before, .header-three .alt-menu-icon a:hover .icon-bar:after,.header-three .alt-menu-icon a:focus .icon-bar:after,.header-three .alt-menu-icon a:active .icon-bar:after {background-color: #000000;}@media only screen and (max-width: 991px) {.mobile-menu-container .slicknav_menu .slicknav_menutxt {color: #ffffff;}.mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span, .mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span:first-child:before,.mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span:first-child:after {background-color: #ffffff;}.mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_menutxt,.mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_menutxt,.mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_menutxt,.slicknav_menu .slicknav_nav li a:hover, .slicknav_menu .slicknav_nav li a:focus, .slicknav_menu .slicknav_nav li a:active {color: #000000;}.mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span, .mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span, .mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span, .mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span:first-child:before,.mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span:first-child:before,.mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span:first-child:before,.mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span:first-child:after,.mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span:first-child:after,.mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span:first-child:after {background-color: #000000;}}/* Transparent Top Header */.transparent-header .header-two.site-header .top-header {background-color: ;}/* Site Title */.transparent-header .site-header.header-two:not(.sticky-header) .site-branding .site-title {color: #ffffff;}/* Tagline */.transparent-header .site-header.header-two:not(.sticky-header) .site-branding .site-description {color: #e6e6e6;}/* Top Header Color */.transparent-header .header-two.site-header .header-contact ul a,.transparent-header .header-two.site-header .header-contact ul li,.transparent-header .header-two.site-header .social-profile ul li a, .transparent-header .header-two.site-header .header-search-wrap .search-icon {color: #ffffff;}.transparent-header .header-two.site-header .header-contact ul a:hover,.transparent-header .header-two.site-header .header-contact ul a:focus,.transparent-header .header-two.site-header .header-contact ul a:active,.transparent-header .header-two.site-header .social-profile ul li a:hover, .transparent-header .header-two.site-header .social-profile ul li a:focus, .transparent-header .header-two.site-header .social-profile ul li a:active, .transparent-header .header-two.site-header .header-search-wrap .search-icon:hover,.transparent-header .header-two.site-header .header-search-wrap .search-icon:focus,.transparent-header .header-two.site-header .header-search-wrap .search-icon:active {color: #ffffff;}.transparent-header .header-two:not(.sticky-header) .alt-menu-icon .icon-bar,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon .icon-bar:before, .transparent-header .header-two:not(.sticky-header) .alt-menu-icon .icon-bar:after {background-color: #ffffff;}.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar:before, .transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar:before, .transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:active .icon-bar:before, .transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:hover .icon-bar:after,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:focus .icon-bar:after,.transparent-header .header-two:not(.sticky-header) .alt-menu-icon a:active .icon-bar:after {background-color: #ffffff;}/* Transparent bottom Header */.transparent-header .header-two.site-header .bottom-header .overlay {background-color: #926548;}/* Header Menu */.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu > li > a {color: #ffffff;}@media only screen and (max-width: 991px) {.transparent-header .header-two .alt-menu-icon .iconbar-label {color: #ffffff;}.transparent-header .header-two .alt-menu-icon a:hover .iconbar-label,.transparent-header .header-two .alt-menu-icon a:focus .iconbar-label,.transparent-header .header-two .alt-menu-icon a:active .iconbar-label {color: #ffffff;}.transparent-header .header-two:not(.sticky-header) .mobile-menu-container .slicknav_menu .slicknav_menutxt {color: #ffffff;}.transparent-header .header-two:not(.sticky-header) .mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span, .transparent-header .header-two:not(.sticky-header) .mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span:first-child:before, .transparent-header .header-two:not(.sticky-header) .mobile-menu-container .slicknav_menu .slicknav_btn .slicknav_icon span:first-child:after {background-color: #ffffff;}}/* Transparent Header bottom Hover Color*/.transparent-header .site-header.header-two:not(.sticky-header) .site-branding .site-title a:hover,.transparent-header .site-header.header-two:not(.sticky-header) .site-branding .site-title a:focus,.transparent-header .site-header.header-two:not(.sticky-header) .site-branding .site-title a:active,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li > a:hover,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li > a:focus,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li > a:active,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li:hover > a, .transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li:focus > a, .transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li:active > a,.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_menutxt,.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_menutxt,.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_menutxt,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li.current-menu-item > a,.transparent-header .header-two:not(.sticky-header) .main-navigation ul.menu li.current_page_item > a {color: #ffffff;}.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span:first-child:before, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span:first-child:before, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span:first-child:before, .transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:hover .slicknav_icon span:first-child:after,.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:focus .slicknav_icon span:first-child:after,.transparent-header .header-two .mobile-menu-container .slicknav_menu .slicknav_btn:active .slicknav_icon span:first-child:after {background-color: #ffffff;}.transparent-header .header-two.sticky-header .bottom-header .overlay {background-color: ;}/* Site Title */.transparent-header .header-two.sticky-header .site-branding .site-title {color: ;}/* Tagline */.transparent-header .header-two.sticky-header .site-branding .site-description {color: ;}/* Header Menu */.transparent-header .header-two.sticky-header .main-navigation ul.menu > li > a {color: ;}/* Hover */.transparent-header .header-two.sticky-header .site-branding .site-title a:hover,.transparent-header .header-two.sticky-header .site-branding .site-title a:focus,.transparent-header .header-two.sticky-header .site-branding .site-title a:active, .transparent-header .header-two.sticky-header .main-navigation ul.menu li > a:hover,.transparent-header .header-two.sticky-header .main-navigation ul.menu li > a:focus,.transparent-header .header-two.sticky-header .main-navigation ul.menu li > a:active,.transparent-header .header-two.sticky-header .main-navigation ul.menu li:hover > a, .transparent-header .header-two.sticky-header .main-navigation ul.menu li:focus > a, .transparent-header .header-two.sticky-header .main-navigation ul.menu li:active > a,.transparent-header .header-two.sticky-header .main-navigation ul.menu li.current-menu-item > a,.transparent-header .header-two.sticky-header .main-navigation ul.menu li.current_page_item > a {color: #000000;}/* Header Button */.transparent-header .header-two.sticky-header .header-btn .button-primary {background-color: ;color: ;}.transparent-header .header-two.sticky-header .header-btn .button-outline {color: ;border-color: ;}.transparent-header .header-two.sticky-header .header-btn .button-text {color: ;padding: 0;}#masthead .main-navigation ul.menu ul li a:hover,#masthead .main-navigation ul.menu ul li a:focus,#masthead .main-navigation ul.menu ul li a:active,#masthead .header-navigation ul.menu ul li a:hover,#masthead .header-navigation ul.menu ul li a:focus,#masthead .header-navigation ul.menu ul li a:active {color: #ffffff;}.header-two.sticky-header .header-btn-1.button-outline {border-color: #1a1a1a;color: #1a1a1a;}.site-header .header-btn-1.button-outline {border-color: #ffffff;color: #ffffff;}.site-header .header-btn-1.button-outline:hover,.site-header .header-btn-1.button-outline:focus,.site-header .header-btn-1.button-outline:active,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:hover,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:focus,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:active {background-color: #086abd;border-color: #086abd;color: #ffffff;}.site-header .header-btn-1.button-outline {border-radius: 0px;}.site-header .site-branding img {display: none;}@media screen and (min-width: 992px){.top-header {border-bottom: none;}}@media screen and (max-width: 991px){.top-header {border-bottom: none;}}.site-header.sticky-header .site-branding > a {max-width: 250px;}@media only screen and (min-width: 992px) {.site-header:not(.sticky-header) .header-image-wrap {height: 80px;width: 100%;position: relative;}}.header-slide-item {background-position: center center;background-repeat: no-repeat;background-size: cover;}@media only screen and (min-width: 768px) {.overlay-post .inner-banner-content {height: 400px;overflow: hidden;}}.overlay-post .inner-banner-content {background-position: center center;background-repeat: no-repeat;background-size: cover;}.overlay-post .inner-banner-content:before { background-color: rgba(0, 0, 0, 0.4);}@media only screen and (min-width: 768px) {.overlay-page .inner-banner-content {height: 400px;overflow: hidden;}}.overlay-page .inner-banner-content {background-position: center center;background-repeat: no-repeat;background-size: cover;}.overlay-page .inner-banner-content:before { background-color: rgba(0, 0, 0, 0.4);}@media only screen and (min-width: 768px) {.banner-img {height: 650px;overflow: hidden;}}.main-slider .banner-img .overlay {background-color: ;}.section-banner .banner-content .entry-title {color: #ffffff;}.banner-content .entry-content .entry-header .cat-links a {color: #ebebeb;border-color: #ebebeb;}.section-banner .banner-content .entry-meta a {color: #ebebeb;}.section-banner .banner-content .entry-meta a:before {color: #FFFFFF;} .section-banner .entry-text {color: #ffffff;}.banner-content .entry-content .entry-header .cat-links a:hover, .banner-content .entry-content .entry-header .cat-links a:focus, .banner-content .entry-content .entry-header .cat-links a:active,.banner-content .entry-title a:hover,.banner-content .entry-title a:focus,.banner-content .entry-title a:active,.section-banner .banner-content .entry-meta a:hover, .section-banner .banner-content .entry-meta a:focus, .section-banner .banner-content .entry-meta a:active,.section-banner .banner-content .entry-meta a:hover:before, .section-banner .banner-content .entry-meta a:focus:before, .section-banner .banner-content .entry-meta a:active:before {color: #ac9bf9;}.banner-content .entry-content .entry-header .cat-links a:hover,.banner-content .entry-content .entry-header .cat-links a:focus,.banner-content .entry-content .entry-header .cat-links a:active,.slick-control li.slick-arrow:not(.slick-disabled):hover span, .slick-control li.slick-arrow:not(.slick-disabled):focus span, .slick-control li.slick-arrow:not(.slick-disabled):active span {border-color: #ac9bf9;}.section-banner .slide-inner .banner-content .button-container .button-outline {border-color: #ffffff;color: #ffffff;}.section-banner .slide-inner .banner-content .button-container .button-outline:hover,.section-banner .slide-inner .banner-content .button-container .button-outline:focus,.section-banner .slide-inner .banner-content .button-container .button-outline:active {background-color: #a8d8ff;border-color: #a8d8ff;color: #FFFFFF;}.section-banner .slide-inner .banner-content .button-container a {border-radius: 0px;}.main-slider .banner-img {background-position: center center;background-repeat: no-repeat;background-size: cover;}.site-footer.has-footer-bg .site-footer-inner {background-position: center center;background-repeat: no-repeat;background-size: cover;}.footer-widget-wrap {padding-top: 30px;padding-bottom: 30px;}.top-footer {background-color: <?php echo $bgcolor;	?>;}.site-footer h1, .site-footer h2, .site-footer h3, .site-footer h4, .site-footer h5, .site-footer h6,.site-footer .product-title {color: #ffffff;}.site-footer .widget .widget-title:before {background-color: #ffffff;}.site-footer a, .site-footer .widget ul li a,.site-footer .widget .tagcloud a,.site-footer .post .entry-meta a,.site-footer .post .entry-meta a:before {color: #ffffff;}.widget ul li,.latest-posts-widget .post {border-bottom-color: rgba(255,255,255,0.2);}.site-footer .widget .tagcloud a {border-color: #ffffff;}.site-footer,.site-footer table th, .site-footer table td,.site-footer .widget.widget_calendar table {color: #ffffff;}.site-footer a:hover, .site-footer a:focus, .site-footer a:active, .site-footer .widget ul li a:hover, .site-footer .widget ul li a:focus, .site-footer .widget ul li a:active,.site-footer .post .entry-meta a:hover, .site-footer .post .entry-meta a:focus, .site-footer .post .entry-meta a:active,.site-footer .post .entry-meta a:hover:before, .site-footer .post .entry-meta a:focus:before, .site-footer .post .entry-meta a:active:before {color: #ffffff;}.site-footer .widget .tagcloud a:hover,.site-footer .widget .tagcloud a:focus,.site-footer .widget .tagcloud a:active {background-color: #ffffff;border-color: #ffffff;color: #FFFFFF;}.bottom-footer {padding-top: 0px;padding-bottom: 30px;}.bottom-footer {background-color: #926548;}.bottom-footer {color: #dddddd;}.site-footer .social-profile ul li a {background-color: rgba(255,255,255,0.1);}.site-info a, .site-footer .social-profile ul li a, .footer-menu ul li a {color: #ffffff;}.site-footer .site-info a:hover, .site-footer .site-info a:focus, .site-footer .site-info a:active, .site-footer .footer-menu ul li a:hover,.site-footer .footer-menu ul li a:focus,.site-footer .footer-menu ul li a:active {color: #ffffff;}.site-footer .social-profile ul li a:hover, .site-footer .social-profile ul li a:focus, .site-footer .social-profile ul li a:active {background-color: #ffffff;}.site-footer .social-profile ul li a {font-size: 18px;}.feature-posts-content-wrap .feature-posts-image {background-position: center center;background-repeat: no-repeat;background-size: cover;}.feature-posts-content-wrap .feature-posts-image {border-radius: 10px;overflow: hidden;}.feature-posts-layout-one .feature-posts-image {-webkit-align-items: flex-end;-moz-align-items: flex-end;-ms-align-items: flex-end;-ms-flex-align: flex-end;align-items: flex-end;}.feature-posts-layout-one .feature-posts-content {margin-bottom: 20px;}.preloader-content {max-width: 40px;overflow: hidden;display: inline-block;}#primary article .entry-title {color: #190961;}#primary article .entry-title a:hover, #primary article .entry-title a:focus, #primary article .entry-title a:active {color: #190961;}#primary article .entry-content .entry-header .cat-links a,#primary article .attachment .entry-content .entry-header .cat-links a {color: #5733ff;}#primary article .entry-content .entry-header .cat-links a {border-color: #5733ff;}#primary article .entry-content .entry-header .cat-links a:hover, #primary article .entry-content .entry-header .cat-links a:focus, #primary article .entry-content .entry-header .cat-links a:active {color: #190961;border-color: #190961;}#primary article .entry-meta a {color: #7a7a7a;}#primary article .entry-meta a:before {color: #5733ff;}#primary article .entry-meta a:hover,#primary article .entry-meta a:focus,#primary article .entry-meta a:active,#primary article .entry-meta a:hover:before,#primary article .entry-meta a:focus:before,#primary article .entry-meta a:active:before {color: #190961;}#primary article .entry-text {color: #333333;}#primary article .featured-image a {border-radius: 10px;}#primary article.sticky .featured-image a { border-radius: 0px;}article.sticky {border-radius: 10px;}.feature-posts-content .feature-posts-title {color: #FFFFFF;}.feature-posts-layout-one .feature-posts-content .feature-posts-title a:after {background-color: #FFFFFF;}.feature-posts-content .feature-posts-title a:hover, .feature-posts-content .feature-posts-title a:focus, .feature-posts-content .feature-posts-title a:active {color: #ac9bf9;}.feature-posts-layout-one .feature-posts-content .feature-posts-title a:hover:after, .feature-posts-layout-one .feature-posts-content .feature-posts-title a:focus:after, .feature-posts-layout-one .feature-posts-content .feature-posts-title a:active:after {background-color: #ac9bf9;}.feature-posts-content .cat-links a {color: #FFFFFF;}.feature-posts-layout-one .feature-posts-content .cat-links a {background-color: #5733ff;}.feature-posts-layout-one .feature-posts-content .cat-links a:hover,.feature-posts-layout-one .feature-posts-content .cat-links a:focus,.feature-posts-layout-one .feature-posts-content .cat-links a:active {background-color: #ac9bf9;color: #FFFFFF;}.post .feature-posts-content .entry-meta a {color: #FFFFFF;}.post .feature-posts-content .entry-meta a:before {color: #FFFFFF;}.post .feature-posts-content .entry-meta a:hover, .post .feature-posts-content .entry-meta a:focus, .post .feature-posts-content .entry-meta a:active,.post .feature-posts-content .entry-meta a:hover:before, .post .feature-posts-content .entry-meta a:focus:before, .post .feature-posts-content .entry-meta a:active:before {color: #ac9bf9;}.feature-posts-layout-one .feature-posts-image {height: 300px;overflow: hidden;}.feature-posts-layout-one .feature-posts-content .feature-posts-title a:after {display: none;}.highlight-post-slider .post .entry-content .entry-title {color: #1e2944;}.highlight-post-slider .entry-content .entry-title a:hover,.highlight-post-slider .entry-content .entry-title a:focus,.highlight-post-slider .entry-content .entry-title a:active {color: #190961;}.highlight-post-slider .post .cat-links a {background-color: #5733ff;}.highlight-post-slider .post .cat-links a {color: #FFFFFF;}.highlight-post-slider .post .cat-links a:hover,.highlight-post-slider .post .cat-links a:focus,.highlight-post-slider .post .cat-links a:active {background-color: #190961;color: #FFFFFF;}.highlight-post-slider .post .entry-meta a {color: #7a7a7a;}.highlight-post-slider .post .entry-meta a:before {color: #5733ff;}.highlight-post-slider .post .entry-meta a:hover,.highlight-post-slider .post .entry-meta a:focus,.highlight-post-slider .post .entry-meta a:active,.highlight-post-slider .post .entry-meta a:hover:before,.highlight-post-slider .post .entry-meta a:focus:before,.highlight-post-slider .post .entry-meta a:active:before {color: #190961;}.section-highlight-post .featured-image a {border-radius: 10px;overflow: hidden;}@media screen and (max-width: 767px){#back-to-top {display: none !important;}}.woocommerce .products li.product .woo-product-image img {border-radius: 0px;}.woocommerce .button-cart_button_two a.button {background-color: #333333;color: #ffffff;}.woocommerce .button-cart_button_three > a.button {border-bottom-color: #ffffff;color: #ffffff;}.woocommerce .button-cart_button_four > a.button {background-color: #333333;color: #ffffff;}.woocommerce ul.products li.product .button-cart_button_two a.button:hover,.woocommerce ul.products li.product .button-cart_button_two a.button:focus,.woocommerce ul.products li.product .button-cart_button_four > a.button:hover,.woocommerce ul.products li.product .button-cart_button_four > a.button:focus {background-color: #5733ff;color: #FFFFFF;}.woocommerce ul.products li.product .button-cart_button_three > a.button:hover,.woocommerce ul.products li.product .button-cart_button_three > a.button:focus {border-color: #5733ff;color: #5733ff;}.woocommerce .button-cart_button_four > a.button {border-radius: 0px;}.woocommerce .button-cart_button_two a.button {border-radius: 0px;}.woocommerce ul.products li.product .button-cart_button_four {left: 10px;bottom: 10px;}.woocommerce ul.products li.product .onsale {top: 8px;right: 8px;}.woocommerce ul.products li.product span.onsale {background-color: #EB5A3E;color: #ffffff;}.woocommerce ul.products li.product span.onsale {border-radius: 0px;}body[class*=woocommerce] ul.products li .product-compare-wishlist a {opacity: 0;z-index: 99;}body[class*=woocommerce] ul.products li .product-wishlist a {top: 50%;left: 50%;-webkit-transform: translate(-50%, -50%);-moz-transform: translate(-50%, -50%);-ms-transform: translate(-50%, -50%);-o-transform: translate(-50%, -50%);transform: translate(-50%, -50%);}body[class*=woocommerce] ul.products li .product-compare a {top: 50%;left: 50%;-webkit-transform: translate(-60px, -50%);-moz-transform: translate(-60px, -50%);-ms-transform: translate(-60px, -50%);-o-transform: translate(-60px, -50%);transform: translate(-60px, -50%);}body[class*=woocommerce] ul.products li .product-view a {top: 50%;left: 50%;-webkit-transform: translate(25px, -50%);-moz-transform: translate(25px, -50%);-ms-transform: translate(25px, -50%);-o-transform: translate(25px, -50%);transform: translate(25px, -50%);}body[class*=woocommerce] ul.products li .product-compare-wishlist a i {background-color: #ffffff;border-radius: 100px;line-height: 35px;height: 35px;text-align: center;width: 35px;}body[class*=woocommerce] ul.products li:hover .product-compare-wishlist a, body[class*=woocommerce] ul.products li:focus .product-compare-wishlist a {opacity: 1;}body[class*=woocommerce] ul.products li .product-compare-wishlist a i {background-color: #ffffff;}body[class*=woocommerce] ul.products li .product-compare-wishlist a i {color: #383838;}.woocommerce ul.products li.product .product-inner {text-align: center;}</style><meta name="generator" content="Elementor 3.22.3; features: e_optimized_assets_loading, e_optimized_css_loading, e_font_icon_svg, additional_custom_breakpoints, e_optimized_control_loading, e_lazyload; settings: css_print_method-external, google_font-enabled, font_display-swap">
			<style>
				.e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload),
				.e-con.e-parent:nth-of-type(n+4):not(.e-lazyloaded):not(.e-no-lazyload) * {
					background-image: none !important;
				}
				@media screen and (max-height: 1024px) {
					.e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload),
					.e-con.e-parent:nth-of-type(n+3):not(.e-lazyloaded):not(.e-no-lazyload) * {
						background-image: none !important;
					}
				}
				@media screen and (max-height: 640px) {
					.e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload),
					.e-con.e-parent:nth-of-type(n+2):not(.e-lazyloaded):not(.e-no-lazyload) * {
						background-image: none !important;
					}
				}
			</style>
			<link rel="icon" href="wp-content/uploads/2024/08/191-1919002_islamic-calendar-indian-temple-icon-png-removebg-preview-150x150.html" sizes="32x32" />
<link rel="icon" href="wp-content/uploads/2024/08/191-1919002_islamic-calendar-indian-temple-icon-png-removebg-preview.html" sizes="192x192" />
<link rel="apple-touch-icon" href="wp-content/uploads/2024/08/191-1919002_islamic-calendar-indian-temple-icon-png-removebg-preview.html" />
<meta name="msapplication-TileImage" content="https://kedarnathdarshan.net/wp-content/uploads/2024/08/191-1919002_islamic-calendar-indian-temple-icon-png-removebg-preview.webp" />
<style>/* Site Title */.header-fifteen .site-branding .site-title {color: #ffffff;}/* Tagline */.header-fifteen .site-branding .site-description {color: #767676;}.header-fifteen .top-header {background-color: #ffffff;}.header-fifteen .header-navigation ul li a,.header-fifteen .social-profile ul li a,.header-fifteen .header-contact a {color: #ffffff;}.header-fifteen .top-header .header-text {color: #333333;}.header-fifteen .alt-menu-icon .icon-bar, .header-fifteen .alt-menu-icon .icon-bar:before, .header-fifteen .alt-menu-icon .icon-bar:after {background-color: #ffffff;}.header-fifteen .header-navigation ul li a:hover,.header-fifteen .header-navigation ul li a:focus,.header-fifteen .social-profile ul li a:hover,.header-fifteen .social-profile ul li a:focus{color: #ffffff;}.header-fifteen .alt-menu-icon a:hover .icon-bar, .header-fifteen .alt-menu-icon a:hover .icon-bar:before, .header-fifteen .alt-menu-icon a:hover .icon-bar:after,.header-fifteen .alt-menu-icon a:focus .icon-bar, .header-fifteen .alt-menu-icon a:focus .icon-bar:before, .header-fifteen .alt-menu-icon a:focus .icon-bar:after {background-color: #ffffff;}.mid-header .overlay {background-color: ;}.mid-header .header-cart a.cart-contents, .mid-header .header-my-account a, .mid-header .header-wishlist a, .mid-header .header-compare a {color: #333333;}.mid-header .header-cart a.cart-contents:hover, .mid-header .header-cart a.cart-contents:focus, .mid-header .header-cart a.cart-contents:active,.header-fifteen .site-branding .site-title a:hover,.header-fifteen .site-branding .site-title a:focus,.mid-header .header-my-account a:hover, .mid-header .header-my-account a:focus, .mid-header .header-my-account a:active, .mid-header .header-wishlist a:hover, .mid-header .header-wishlist a:focus, .mid-header .header-wishlist a:active, .mid-header .header-compare a:hover,.mid-header .header-compare a:focus,.mid-header .header-compare a:active {color: #086abd;}@media only screen and (min-width: 992px) {.site-header:not(.sticky-header) .header-image-wrap {height: 80px;width: 100%;position: relative;}}.header-category-nav .navbar-nav > li > a {background-color: #333333;color: #ffffff;}.header-fifteen .bottom-header {background-color: ;}.header-fifteen .main-navigation ul.menu > li > a,.header-fifteen .header-search-form button.header-search-button {color: #ffffff;}@media only screen and (min-width: 991px) { .header-fifteen .header-search-form input.header-search-input {color: #ffffff;}.header-fifteen .header-search-form {border-left-color: rgba(255,255,255,0.1);border-right-color: rgba(255,255,255,0.1);}.header-fifteen .header-search-form input.header-search-input::-webkit-input-placeholder {color: rgba(255,255,255,0.6);}.header-fifteen .header-search-form input.header-search-input::-moz-placeholder {color:rgba(255,255,255,0.6);}.header-fifteen .header-search-form input.header-search-input:-ms-input-placeholder {color: rgba(255,255,255,0.6);}.header-fifteen .header-search-form input.header-search-input:-moz-placeholder {color: rgba(255,255,255,0.6);}}.header-category-nav .navbar-nav > li > a:hover, .header-category-nav .navbar-nav > li > a:focus {background-color: #000000;}.header-fifteen .main-navigation ul.menu > li:hover > a, .header-fifteen .main-navigation ul.menu > li:focus > a,.header-fifteen .header-search-form button.header-search-button:hover,.header-fifteen .header-search-form button.header-search-button:focus {color: #000000;}.header-fifteen .search-form button:hover,.header-fifteen .search-form button:focus {background-color: #000000;}.header-category-nav .navbar-nav li li a:hover, .header-category-nav .navbar-nav li li a:focus {color: #ffffff;}.feature-posts-layout-one .feature-posts-image {height: 300px;overflow: hidden;}/* Primary Background */.header-cart a.cart-contents span.count {background-color: #5733ff;}/* Primary Hover */.summary .yith-wcwl-add-to-wishlist a:hover i,.summary .yith-wcwl-add-to-wishlist a:focus i {color: #5733ff;border-color: #5733ff;}.feature-pages-content .feature-pages-title {color: #1a1a1a;}.feature-pages-content .feature-pages-title a:hover,.feature-pages-content .feature-pages-title a:focus {color: #086abd;}.feature-pages-layout-one .feature-pages-content-wrap .feature-pages-image:before { background-color: rgba(0, 0, 0, 0.2);}.feature-pages-layout-one .feature-pages-image {height: 250px;overflow: hidden;}.feature-pages-content-wrap .feature-pages-image {background-position: center center;background-repeat: no-repeat;background-size: cover;}.feature-pages-content-wrap .feature-pages-image {border-radius: 0px;overflow: hidden;}.feature-pages-layout-one .feature-pages-image {-webkit-align-items: center;-moz-align-items: center;-ms-align-items: center;-ms-flex-align: center;align-items: center;}.section-feature-posts-two-area .feature-posts-content .feature-posts-title {color: #FFFFFF;}.section-feature-posts-two-area .feature-posts-content .feature-posts-title a:hover,.section-feature-posts-two-area .feature-posts-content .feature-posts-title a:focus {color: #ac9bf9;}.section-feature-posts-two-area .feature-posts-content .cat-links a {background-color: #5733ff;color: #FFFFFF;}.section-feature-posts-two-area .feature-posts-content .cat-links a:hover,.section-feature-posts-two-area .feature-posts-content .cat-links a:focus {background-color: #ac9bf9;color: #FFFFFF;}.section-feature-posts-two-area .feature-posts-content .entry-meta a {color: #FFFFFF;}.section-feature-posts-two-area .feature-posts-content .entry-meta a:before {color: #FFFFFF;}.section-feature-posts-two-area .feature-posts-content .entry-meta a:hover,.section-feature-posts-two-area .feature-posts-content .entry-meta a:focus,.section-feature-posts-two-area .feature-posts-content .entry-meta a:hover:before,.section-feature-posts-two-area .feature-posts-content .entry-meta a:focus:before {color: #ac9bf9;}.section-feature-posts-two-area .feature-posts-image:before { background-color: rgba(0, 0, 0, 0.4);}.section-feature-posts-two-area .feature-posts-image {background-position: center center;background-repeat: no-repeat;background-size: cover;}.section-feature-posts-two-area .feature-posts-image {border-radius: 0px;overflow: hidden;}.section-feature-posts-two-area .feature-posts-image {-webkit-align-items: flex-end;-moz-align-items: flex-end;-ms-align-items: flex-end;-ms-flex-align: flex-end;align-items: flex-end;}.section-feature-posts-two-area .feature-posts-content {margin-bottom: 20px;}.header-cart a.cart-contents span.count {background-color: #EB5A3E;}.header-cart a.cart-contents span.count {color: #ffffff;}.header-two.sticky-header .header-btn-1.button-outline {border-color: #1a1a1a;color: #1a1a1a;}.site-header .header-btn-1.button-outline {border-color: #ffffff;color: #ffffff;}.site-header .header-btn-1.button-outline:hover,.site-header .header-btn-1.button-outline:focus,.site-header .header-btn-1.button-outline:active,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:hover,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:focus,.transparent-header .header-two.sticky-header .header-btn-1.button-outline:active {background-color: #086abd;border-color: #086abd;color: #ffffff;}.site-header .header-btn-1.button-outline {border-radius: 0px;}</style>		<style type="text/css" id="wp-custom-css">
			.header-icons .social-profile ul li a {
	font-size: 14px;
	background: #5733FF;
	border-radius: 99px;
	padding: 8px;
}
.header-icons .social-profile ul li {
	margin: 0 4px !important;
}
.gallery img {
	height: 200px !important;
	object-fit: cover;
}
/* .elementskit-box-style-content {
    text-align: justify !important;
} */
#des .elementskit-box-style-content {
	text-align:justify !important;
}
.header-two .bottom-header .overlay {
	background-color: <?php echo $bgcolor;	?> !important;
}
.wp-block-social-link-anchor {
	background: white;
	border-radius: 99px;
	padding: 5px;
}
.site-title a {
	font-weight: 900;
	font-size: 20px;
	color: #fff !important;
}
.widget h2 {
	font-size: 22px !important;
	font-weight: 700 !important;
}
.sub-menu a {
	font-weight: 800 !important;
}

.transparent-header .header-two .overlay-header {
	background-color: transparent;
	position: unset !important;
	width: 100%;
	top: 0;
	left: 0;
	z-index: 99;
}
html {
    position: relative;
    min-height: 100%;
}
body {
    margin: 0 0 100px; /* bottom = footer height */
}
#colophon {
    position: absolute;
    left: 0;
    bottom: 0;
    height: 100px;
    width: 100%;
}

body {
    /* font-family: 'Aoboshi One' !important; */
}
/* p{
	text-align:justify !important;
} */
.ads{
	padding: 5px 0px;
}
.adsframe{
	width: 39.5vw;
	height: calc(39.50vw / 3.75);
    margin: 0 auto;
	display: flex;
    align-items: center;
    justify-content: center;
	border: 0.5px solid #CCCCCC;
}
.ads img{
	width: 100%;
    height: 100%;
}
@media only screen and (min-width: 712px) and (max-width: 1024px) {
	.des-box {
		width: 50% !important;
	}

	.header-two .mobile-menu-container .slicknav_menu .slicknav_btn {
		position: absolute;
		top: 5px !important;
		right: 20px;
		z-index: 99;
		margin: 0;
	}
/* 	.mail p{
	text-align:center;
} */
}

.gallery .gallery-caption {
	background-color: #926548;
	color: #fff;
	font-size: 15px;
	font-weight: 700 !important;
	padding: 5px 10px;
	border-radius: 0px 0px 10px 10px;
	position: unset !important;
}
.top-footer p {
	text-align: justify !important;
	margin-bottom:0px;
}
.places ul {
	padding-left: 20px !important;
}
.gallery img:hover {
	background-color: red;
	/* opacity: 0.5;
     */
	opacity: 0.5;
	transition: 1s ease;
	-webkit-transform: scale(1.2);
	-ms-transform: scale(1.2);
	transform: scale(1.2);
	transition: 1s ease;
	border-radius: 10px 10px 0px 0px;
}

@media (max-width: 600px) {
 .mail p{
	text-align:center !important;
}

.menu-footer-widget-1-container{
	display: unset !important;
}
.footer-item li{
	border: unset !important;
}
#block-11 h2{
	text-align: unset !important;
}
}
/*  Footer*/
/* #nav_menu-2 a{
	display: flex;
    justify-content: center;
} */
.footer-item li{
	border: unset !important;
}
#block-11 h2{
	text-align: center;
}
#menu-footer-widget-1{
	margin: -20px auto !important;
}
.menu-footer-widget-1-container{
	display: flex;
}
.adsframe h1{
    margin: 0;
	font-size: 15px;
}		</style>
		<style id="kirki-inline-styles">.site-header .header-btn a{font-family:Inter;font-size:13px;font-weight:500;line-height:1.2;}.site-header .site-branding .site-title{font-family:Poppins;font-size:22px;}.site-header .site-branding .site-description{font-family:Poppins;font-size:14px;font-weight:400;text-transform:none;}.main-navigation ul.menu li a,.slicknav_menu .slicknav_nav li a{font-family:Poppins;font-size:15px;font-weight:700;}.main-navigation .menu-description, .slicknav_menu .menu-description{font-family:Poppins;font-size:11px;font-weight:400;line-height:1.3;text-transform:none;}body{font-family:Inter;}h1,h2,h3,h4,h5,h6{font-family:Poppins;}.page-title{font-family:Poppins;}.sidebar .widget .widget-title{font-family:Poppins;}.site-footer .widget .widget-title{font-family:Poppins;font-size:18px;}.site-footer .footer-menu ul li a,.site-footer .site-info{font-size:13px;}.section-banner .banner-content .entry-title{font-family:Poppins;font-size:60px;font-weight:600;text-transform:capitalize;}.section-banner .banner-content .entry-header .cat-links a{font-family:Poppins;font-size:15px;font-weight:400;line-height:1.6;text-transform:uppercase;}.section-banner .banner-content .entry-meta a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1.6;text-transform:capitalize;}.section-banner .banner-content .entry-text p{font-family:Inter;}.section-banner .slide-inner .banner-content .button-container a{font-family:Inter;line-height:1.5;}.post .feature-posts-content .cat-links a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1;text-transform:uppercase;}.post .feature-posts-content .entry-meta a{font-family:Inter;}.section-highlight-post .section-title{font-family:Poppins;font-size:32px;font-weight:600;}.highlight-post-slider .post .cat-links a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1;text-transform:capitalize;}.highlight-post-slider .post .entry-content .entry-title{font-family:Poppins;font-size:17px;font-weight:600;}.highlight-post-slider .post .entry-meta a{font-family:Inter;}#primary article .entry-title{font-family:Poppins;font-size:17px;font-weight:600;}#primary .post .entry-content .entry-header .cat-links a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1;text-transform:uppercase;}#primary .entry-meta{font-family:Inter;}#primary .entry-text p{font-family:Inter;}.button-outline,.button-primary,.button-text,.product-title,.woocommerce a.added_to_cart,body.woocommerce a.button,button,h1,h2,h3,h4,h5,h6,input[type="submit"],span.woocommerce-Price-amount.amount{font-family:Poppins;}.feature-posts-content-wrap .feature-posts-content .feature-posts-title{font-family:Poppins;font-size:17px;font-weight:600;}.section-feature-posts-two-area .feature-posts-content .feature-posts-title{font-family:Jost;font-size:22px;font-weight:500;line-height:1.4;text-transform:capitalize;}.section-feature-posts-two-area .feature-posts-content .cat-links a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1;text-transform:uppercase;}.section-feature-posts-two-area .feature-posts-content .entry-meta a{font-family:Poppins;font-size:13px;font-weight:400;line-height:1.6;text-transform:capitalize;}/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJnecmNE.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJfecg.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJnecmNE.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJfecg.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2JL7SUc.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa0ZL7SUc.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2ZL7SUc.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1pL7SUc.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* vietnamese */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa2pL7SUc.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa25L7SUc.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Inter';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/inter/UcC73FwrK3iLTeHuS_nVMrMxCp50SjIa1ZL7.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJnecmNE.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiEyp8kv8JHgFVrJJfecg.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLEj6Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* latin-ext */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1JlFc-K.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Poppins';
  font-style: normal;
  font-weight: 700;
  font-display: swap;
  src: url(wp-content/fonts/poppins/pxiByp8kv8JHgFVrLCz7Z1xlFQ.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 500;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSKmu1aB.woff2) format('woff2');
  unicode-range: U+0460-052F, U+1C80-1C88, U+20B4, U+2DE0-2DFF, U+A640-A69F, U+FE2E-FE2F;
}
/* cyrillic */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSumu1aB.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* greek-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSOmu1aB.woff2) format('woff2');
  unicode-range: U+1F00-1FFF;
}
/* greek */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSymu1aB.woff2) format('woff2');
  unicode-range: U+0370-0377, U+037A-037F, U+0384-038A, U+038C, U+038E-03A1, U+03A3-03FF;
}
/* hebrew */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS2mu1aB.woff2) format('woff2');
  unicode-range: U+0590-05FF, U+200C-2010, U+20AA, U+25CC, U+FB1D-FB4F;
}
/* math */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTVOmu1aB.woff2) format('woff2');
  unicode-range: U+0302-0303, U+0305, U+0307-0308, U+0330, U+0391-03A1, U+03A3-03A9, U+03B1-03C9, U+03D1, U+03D5-03D6, U+03F0-03F1, U+03F4-03F5, U+2034-2037, U+2057, U+20D0-20DC, U+20E1, U+20E5-20EF, U+2102, U+210A-210E, U+2110-2112, U+2115, U+2119-211D, U+2124, U+2128, U+212C-212D, U+212F-2131, U+2133-2138, U+213C-2140, U+2145-2149, U+2190, U+2192, U+2194-21AE, U+21B0-21E5, U+21F1-21F2, U+21F4-2211, U+2213-2214, U+2216-22FF, U+2308-230B, U+2310, U+2319, U+231C-2321, U+2336-237A, U+237C, U+2395, U+239B-23B6, U+23D0, U+23DC-23E1, U+2474-2475, U+25AF, U+25B3, U+25B7, U+25BD, U+25C1, U+25CA, U+25CC, U+25FB, U+266D-266F, U+27C0-27FF, U+2900-2AFF, U+2B0E-2B11, U+2B30-2B4C, U+2BFE, U+FF5B, U+FF5D, U+1D400-1D7FF, U+1EE00-1EEFF;
}
/* symbols */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTUGmu1aB.woff2) format('woff2');
  unicode-range: U+0001-000C, U+000E-001F, U+007F-009F, U+20DD-20E0, U+20E2-20E4, U+2150-218F, U+2190, U+2192, U+2194-2199, U+21AF, U+21E6-21F0, U+21F3, U+2218-2219, U+2299, U+22C4-22C6, U+2300-243F, U+2440-244A, U+2460-24FF, U+25A0-27BF, U+2800-28FF, U+2921-2922, U+2981, U+29BF, U+29EB, U+2B00-2BFF, U+4DC0-4DFF, U+FFF9-FFFB, U+10140-1018E, U+10190-1019C, U+101A0, U+101D0-101FD, U+102E0-102FB, U+10E60-10E7E, U+1D2C0-1D2D3, U+1D2E0-1D37F, U+1F000-1F0FF, U+1F100-1F1AD, U+1F1E6-1F1FF, U+1F30D-1F30F, U+1F315, U+1F31C, U+1F31E, U+1F320-1F32C, U+1F336, U+1F378, U+1F37D, U+1F382, U+1F393-1F39F, U+1F3A7-1F3A8, U+1F3AC-1F3AF, U+1F3C2, U+1F3C4-1F3C6, U+1F3CA-1F3CE, U+1F3D4-1F3E0, U+1F3ED, U+1F3F1-1F3F3, U+1F3F5-1F3F7, U+1F408, U+1F415, U+1F41F, U+1F426, U+1F43F, U+1F441-1F442, U+1F444, U+1F446-1F449, U+1F44C-1F44E, U+1F453, U+1F46A, U+1F47D, U+1F4A3, U+1F4B0, U+1F4B3, U+1F4B9, U+1F4BB, U+1F4BF, U+1F4C8-1F4CB, U+1F4D6, U+1F4DA, U+1F4DF, U+1F4E3-1F4E6, U+1F4EA-1F4ED, U+1F4F7, U+1F4F9-1F4FB, U+1F4FD-1F4FE, U+1F503, U+1F507-1F50B, U+1F50D, U+1F512-1F513, U+1F53E-1F54A, U+1F54F-1F5FA, U+1F610, U+1F650-1F67F, U+1F687, U+1F68D, U+1F691, U+1F694, U+1F698, U+1F6AD, U+1F6B2, U+1F6B9-1F6BA, U+1F6BC, U+1F6C6-1F6CF, U+1F6D3-1F6D7, U+1F6E0-1F6EA, U+1F6F0-1F6F3, U+1F6F7-1F6FC, U+1F700-1F7FF, U+1F800-1F80B, U+1F810-1F847, U+1F850-1F859, U+1F860-1F887, U+1F890-1F8AD, U+1F8B0-1F8B1, U+1F900-1F90B, U+1F93B, U+1F946, U+1F984, U+1F996, U+1F9E9, U+1FA00-1FA6F, U+1FA70-1FA7C, U+1FA80-1FA88, U+1FA90-1FABD, U+1FABF-1FAC5, U+1FACE-1FADB, U+1FAE0-1FAE8, U+1FAF0-1FAF8, U+1FB00-1FBFF;
}
/* vietnamese */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSCmu1aB.woff2) format('woff2');
  unicode-range: U+0102-0103, U+0110-0111, U+0128-0129, U+0168-0169, U+01A0-01A1, U+01AF-01B0, U+0300-0301, U+0303-0304, U+0308-0309, U+0323, U+0329, U+1EA0-1EF9, U+20AB;
}
/* latin-ext */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTSGmu1aB.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Open Sans';
  font-style: normal;
  font-weight: 600;
  font-stretch: 100%;
  font-display: swap;
  src: url(wp-content/fonts/open-sans/memvYaGs126MiZpBA-UvWbX2vVnXBbObj2OVTS-muw.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 400;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 500;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}
/* cyrillic */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oDd4iYl.woff2) format('woff2');
  unicode-range: U+0301, U+0400-045F, U+0490-0491, U+04B0-04B1, U+2116;
}
/* latin-ext */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73ord4iYl.woff2) format('woff2');
  unicode-range: U+0100-02AF, U+0304, U+0308, U+0329, U+1E00-1E9F, U+1EF2-1EFF, U+2020, U+20A0-20AB, U+20AD-20C0, U+2113, U+2C60-2C7F, U+A720-A7FF;
}
/* latin */
@font-face {
  font-family: 'Jost';
  font-style: normal;
  font-weight: 600;
  font-display: swap;
  src: url(wp-content/fonts/jost/92zatBhPNqw73oTd4g.woff2) format('woff2');
  unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+0304, U+0308, U+0329, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD;
}</style></head>

<body class="home page-template page-template-elementor_header_footer page page-id-92 transparent-header default-skin no-sidebar site-layout-default elementor-default elementor-template-full-width elementor-kit-6 elementor-page elementor-page-92">


<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content">Skip to content</a>

	<header id="masthead" class="site-header header-two">
	<div class="overlay-header">
				<div class="top-header">
								</div>	
		<div class="bottom-header header-image-wrap fixed-header">
						<div class="container">
				<div class="row align-items-center">
					<div class="col-lg-3">
						
<div class="site-branding">
					<p class="site-title"><a href="<?php echo $url; ?>" rel="home"><?php echo $city;    ?> </a></p>
				</div><!-- .site-branding -->						<div class="mobile-menu-container"></div>
					</div>
					<div class="col-lg-9 d-none d-lg-block">
						<div class="main-navigation-wrap">
							<nav id="site-navigation" class="main-navigation">
								<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">Primary Menu</button>
								<ul id="primary-menu" class="menu nav-menu">
<li id="menu-item-101" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-92  menu-item-101"><a href="<?php echo $url; ?>" aria-current="page">Home</a></li>
<li id="menu-item-105" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-105"><a href="<?php echo $url; ?>about.php">About Us</a></li>
<li id="menu-item-103" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-103"><a href="<?php echo $url; ?>destination.php">Destination</a></li>
<li id="menu-item-424" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-424"><a href="<?php echo $url; ?>food.php">Food</a></li>
<li id="menu-item-424" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-424"><a href="<?php echo $url; ?>festivals.php">Festivals</a></li>
<li id="menu-item-186" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-186"><a href="<?php echo $url; ?>gallery.php">Gallery</a></li>
<li id="menu-item-102" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-102"><a href="<?php echo $url; ?>contact.php">Contact Us</a></li>
</ul>															</nav><!-- #site-navigation -->
													</div>
					</div>
				</div>
			</div>
			<div class="overlay"></div>
		</div>
	</div>
	<div id="offcanvas-menu" class="offcanvas-menu-wrap">
	<div class="close-offcanvas-menu">
		<button class="fas fa-times"></button>
	</div>
	<div class="offcanvas-menu-inner">
		<div class="offcanvas-menu-content">
									<!-- header secondary menu -->
													<!-- header search field -->
						<!-- header callback button -->
			
		    <!-- header contact details -->
		    			    					<div class="d-lg-none">
						
	<div class="header-contact">
		
	</div>
					</div>
													<!-- header social icons -->		
		</div>
		<!-- header sidebar -->
					<div class="header-sidebar">
				<div id="block-5" class="widget widget_block"><div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow"><h2 class="wp-block-heading">Archives</h2><div class="wp-block-archives-list wp-block-archives">No archives to show.</div></div></div></div><div id="block-6" class="widget widget_block"><div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow"><h2 class="wp-block-heading">Categories</h2><ul class="wp-block-categories-list wp-block-categories"><li class="cat-item-none">No categories</li></ul></div></div></div>			</div>
			
	</div>
</div></header><!-- #masthead -->		<div data-elementor-type="wp-page" data-elementor-id="92" class="elementor elementor-92">
				<div class="elementor-element elementor-element-0e93115 e-con-full e-flex e-con e-parent" data-id="0e93115" data-element_type="container" data-settings="{&quot;background_background&quot;:&quot;classic&quot;}">
				</div>
		<div class="elementor-element elementor-element-a07aced e-con-full e-flex e-con e-parent" data-id="a07aced" data-element_type="container">
		    
				<div class="elementor-element elementor-element-0d17d73 elementor-widget elementor-widget-html" data-id="0d17d73" data-element_type="widget" data-widget_type="html.default">
				<div class="elementor-widget-container">
			<div class="ads" style="margin-top:15px;"></div>
		</div>
				</div>
				</div>
		<div class="elementor-element elementor-element-0e97399 e-grid e-con-boxed e-con e-parent" data-id="0e97399" data-element_type="container">
					<div class="e-con-inner">
		<div class="elementor-element elementor-element-8c22b79 e-con-full e-flex e-con e-child" data-id="8c22b79" data-element_type="container">
				<div class="elementor-element elementor-element-bf9a902 elementor-widget elementor-widget-heading" data-id="bf9a902" data-element_type="widget" data-widget_type="heading.default">
				<div class="elementor-widget-container">
			<style>/*! elementor - v3.22.0 - 26-06-2024 */
.elementor-heading-title{padding:0;margin:0;line-height:1}.elementor-widget-heading .elementor-heading-title[class*=elementor-size-]>a{color:inherit;font-size:inherit;line-height:inherit}.elementor-widget-heading .elementor-heading-title.elementor-size-small{font-size:15px}.elementor-widget-heading .elementor-heading-title.elementor-size-medium{font-size:19px}.elementor-widget-heading .elementor-heading-title.elementor-size-large{font-size:29px}.elementor-widget-heading .elementor-heading-title.elementor-size-xl{font-size:39px}.elementor-widget-heading .elementor-heading-title.elementor-size-xxl{font-size:59px}</style><h1 class="elementor-heading-title elementor-size-default"><?php echo $home['heading'];  ?> </h1>		</div>
				</div>
				<div class="elementor-element elementor-element-97ce008 elementor-widget elementor-widget-text-editor" data-id="97ce008" data-element_type="widget" data-widget_type="text-editor.default">
				<div class="elementor-widget-container">
			<style>/*! elementor - v3.22.0 - 26-06-2024 */
.elementor-widget-text-editor.elementor-drop-cap-view-stacked .elementor-drop-cap{background-color:#69727d;color:#fff}.elementor-widget-text-editor.elementor-drop-cap-view-framed .elementor-drop-cap{color:#69727d;border:3px solid;background-color:transparent}.elementor-widget-text-editor:not(.elementor-drop-cap-view-default) .elementor-drop-cap{margin-top:8px}.elementor-widget-text-editor:not(.elementor-drop-cap-view-default) .elementor-drop-cap-letter{width:1em;height:1em}.elementor-widget-text-editor .elementor-drop-cap{float:left;text-align:center;line-height:1;font-size:50px}.elementor-widget-text-editor .elementor-drop-cap-letter{display:inline-block}</style>				<?php echo $home['headinginfo'];    ?>					



<div class="elementor-widget-container">
			<div class="ekit-wid-con">		<div class="ekit-btn-wraper">
							<a href="<?php echo $url;   ?>about.php" class="elementskit-btn  whitespace--normal" id="">
					Read More				</a>
					</div>
        </div>		</div>



</div>
				</div>
				</div>
		<div class="elementor-element elementor-element-a185cc4 e-con-full e-flex e-con e-child" data-id="a185cc4" data-element_type="container">
				<div class="elementor-element elementor-element-b21614e elementor-widget elementor-widget-image" data-id="b21614e" data-element_type="widget" data-widget_type="image.default">
				<div class="elementor-widget-container">
			<style>/*! elementor - v3.22.0 - 26-06-2024 */
.elementor-widget-image{text-align:center}.elementor-widget-image a{display:inline-block}.elementor-widget-image a img[src$=".svg"]{width:48px}.elementor-widget-image img{vertical-align:middle;display:inline-block}</style>										



<?php
$img = $home['headingimg'];

$img300 = str_replace("-og",'-300x200',$img);

$img2048 = str_replace("-og",'-2048x1365',$img);

$img1024 = str_replace("-og",'-1024x683',$img);

$img768 = str_replace("-og",'-768x512',$img);

$img1536 = str_replace("-og",'-1536x1024',$img);

?>
<img fetchpriority="high" decoding="async" width="2048" height="1365" src="<?php echo $home['headingimg'];  ?>" class="attachment-full size-full wp-image-1048" alt="<?php echo $city;  ?>" srcset="<?php echo $img2048;	?> 2048w, <?php echo $img300;	?> 300w, <?php echo $img1024;	?> 1024w, <?php echo $img768;	?> 768w, <?php echo $img1536;	?> 1536w"  sizes="(max-width: 2048px) 100vw, 2048px" />


				</div>
				</div>
					</div>
				</div>
		<!--<div class="elementor-element elementor-element-d73cfe2 e-con-full e-flex e-con e-parent" data-id="d73cfe2" data-element_type="container" style="margin:auto;">-->
		<!--		<div class="elementor-element elementor-element-fa2d53f elementor-widget elementor-widget-html" data-id="fa2d53f" data-element_type="widget" data-widget_type="html.default">-->
		<!--		<div class="elementor-widget-container">-->
		<!--	<div class="ads"></div>-->

		<!--</div>-->
		<!--		</div>-->
		<!--		</div>-->
		<div class="elementor-element elementor-element-06936f1 e-flex e-con-boxed e-con e-parent" data-id="06936f1" data-element_type="container">
		    
					<div class="e-con-inner">
		<div class="elementor-element elementor-element-461f86c e-con-full e-flex e-con e-child" data-id="461f86c" data-element_type="container">
				<div class="elementor-element elementor-element-5f392da elementor-widget elementor-widget-heading" data-id="5f392da" data-element_type="widget" data-widget_type="heading.default">
				<div class="elementor-widget-container">
			<h2 class="elementor-heading-title elementor-size-default">Our Destination</h2>		</div>
				</div>
				</div>
					</div>
				</div>
		<div class="elementor-element elementor-element-4edc34d gallery des e-flex e-con-boxed e-con e-parent" data-id="4edc34d" data-element_type="container">
					<div class="e-con-inner">
					    
		                
		                
		                
		                
		                
		                
		  <?php
		  
		  $top = $home['top'];
		  foreach($top as $t) {
		      
		      
		  ?>
		                
		                
		                <div class="elementor-element elementor-element-c40f8bb e-con-full des-box e-flex e-con e-child" data-id="c40f8bb" data-element_type="container">
				<div class="elementor-element elementor-element-cf212a8 ekit-equal-height-enable elementor-widget elementor-widget-elementskit-image-box" data-id="cf212a8" data-element_type="widget" data-widget_type="elementskit-image-box.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con">
            <div class="elementskit-info-image-box ekit-image-box text-center style-modern">

                
                <div class="elementskit-box-header image-box-img-center">
                    <?php
                    $img = $t['img'];
                    
                    $img0 = str_replace("-og",'-770x516',$img);

                    $img1 = str_replace("-og",'-300x201',$img);

                    $img2 = str_replace("-og",'-768x514',$img);
                    
                    ?>

<img decoding="async" width="720" height="375" src="<?php echo $t['img'];   ?>" class="attachment-full size-full wp-image-1837" alt="<?php echo $t['alt'];   ?>" srcset="<?php echo $img0;	?> 770w, <?php echo $img1;	?> 300w, <?php echo $img2;	?> 768w" sizes="(max-width: 770px) 100vw, 770px">
                </div>
                
                <div class="elementskit-box-body ekit-image-box-body">
                    <div class="elementskit-box-content ekit-image-box-body-inner">
                                                <h3 class="elementskit-info-box-title">

                        <?php echo $t['alt'];   ?>
                        
                    </h3>
                                                            <div class="elementskit-box-style-content">
                        <?php echo $t['content'];   ?>                 </div>
                                    </div>

                                <div class="elementskit-box-footer">
                    <div class="box-footer">
                        <div class="btn-wraper">
                                                            <a href="<?php echo $url;   ?>destination.php" class="elementskit-btn whitespace--normal">
                                    View More                                </a>
                                                    </div>
                    </div>
                </div>
                            </div>
            </div>
    </div>		</div>
				</div>
				</div>
				
				
				
				
		    <?php
		  }
		  ?>
				
				
		               
		               
		               </div>
		          </div>
		                
		                
		                
		      
		      
		      <div class="elementor-element elementor-element-28d4d2e e-flex e-con-boxed e-con e-parent" data-id="28d4d2e" data-element_type="container">
					<div class="e-con-inner">
				<div class="elementor-element elementor-element-d73eaa0 elementor-widget elementor-widget-elementskit-button" data-id="d73eaa0" data-element_type="widget" data-widget_type="elementskit-button.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con" >		<div class="ekit-btn-wraper">
							<a href="<?php echo $url;   ?>destination.php" class="elementskit-btn  whitespace--normal" id="">
					More Destination				</a>
					</div>
        </div>		</div>
				</div>
					</div>
				</div>
		                
		                
		                
		                
		                
				<?php
				
				// check if festival is enabled 
				
				$enabled = $home['festivalenable'];
				
				if($enabled=='1') {
				    
				?>
				
				<div class="elementor-element elementor-element-d73cfe2 e-con-full e-flex e-con e-parent" data-id="d73cfe2" data-element_type="container" style="margin:auto;">
				<div class="elementor-element elementor-element-fa2d53f elementor-widget elementor-widget-html" data-id="fa2d53f" data-element_type="widget" data-widget_type="html.default">
				<div class="elementor-widget-container">
			<div class="ads"></div>

		</div>
				</div>
				</div>
				
				<div class="elementor-element elementor-element-06936f1 e-flex e-con-boxed e-con e-parent" data-id="06936f1" data-element_type="container">
		    
					<div class="e-con-inner">
		<div class="elementor-element elementor-element-461f86c e-con-full e-flex e-con e-child" data-id="461f86c" data-element_type="container">
				<div class="elementor-element elementor-element-5f392da elementor-widget elementor-widget-heading" data-id="5f392da" data-element_type="widget" data-widget_type="heading.default">
				<div class="elementor-widget-container">
			<h2 class="elementor-heading-title elementor-size-default">Festivals</h2>		</div>
				</div>
				</div>
					</div>
				</div>
		<div class="elementor-element elementor-element-4edc34d gallery des e-flex e-con-boxed e-con e-parent" data-id="4edc34d" data-element_type="container">
					<div class="e-con-inner">
					    
		                
		                
		                
		                
		                
		                
		  <?php
		  
		  $top = $home['festival'];
		  foreach($top as $t) {
		      
		      
		  ?>
		                
		                
		                <div class="elementor-element elementor-element-c40f8bb e-con-full des-box e-flex e-con e-child" data-id="c40f8bb" data-element_type="container">
				<div class="elementor-element elementor-element-cf212a8 ekit-equal-height-enable elementor-widget elementor-widget-elementskit-image-box" data-id="cf212a8" data-element_type="widget" data-widget_type="elementskit-image-box.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con">
            <div class="elementskit-info-image-box ekit-image-box text-center style-modern">

                
                <div class="elementskit-box-header image-box-img-center">
                    <?php
                    $img = $t['img'];
                    
                    $img0 = str_replace("-og",'-770x516',$img);

                    $img1 = str_replace("-og",'-300x201',$img);

                    $img2 = str_replace("-og",'-768x514',$img);
                    
                    ?>

<img decoding="async" width="720" height="375" src="<?php echo $t['img'];   ?>" class="attachment-full size-full wp-image-1837" alt="<?php echo $t['alt'];   ?>" srcset="<?php echo $img0;	?> 770w, <?php echo $img1;	?> 300w, <?php echo $img2;	?> 768w" sizes="(max-width: 770px) 100vw, 770px">
                </div>
                
                <div class="elementskit-box-body ekit-image-box-body">
                    <div class="elementskit-box-content ekit-image-box-body-inner">
                                                <h3 class="elementskit-info-box-title">

                        <?php echo $t['alt'];   ?>
                        
                    </h3>
                                                            <div class="elementskit-box-style-content">
                        <?php echo $t['content'];   ?>                 </div>
                                    </div>

                                <div class="elementskit-box-footer">
                    <div class="box-footer">
                        <div class="btn-wraper">
                                                            <a href="<?php echo $url;   ?>festivals.php" class="elementskit-btn whitespace--normal">
                                    View More                                </a>
                                                    </div>
                    </div>
                </div>
                            </div>
            </div>
    </div>		</div>
				</div>
				</div>
				
				
				
				
				
				
				
		    <?php
		  }
		  ?>
		  </div>
				</div>
		  
		  <div class="elementor-element elementor-element-28d4d2e e-flex e-con-boxed e-con e-parent" data-id="28d4d2e" data-element_type="container">
					<div class="e-con-inner">
				<div class="elementor-element elementor-element-d73eaa0 elementor-widget elementor-widget-elementskit-button" data-id="d73eaa0" data-element_type="widget" data-widget_type="elementskit-button.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con" >		<div class="ekit-btn-wraper">
							<a href="<?php echo $url;   ?>festivals.php" class="elementskit-btn  whitespace--normal" id="">
					More Festivals				</a>
					</div>
        </div>		</div>
				</div>
					</div>
				</div>
				
				<?php
		  
				}// check if festival is enabled 
		  ?>
				
				
		                
		                
		                
		                
		                
		                
		                
					
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
				
		
				
				<?php
				/*
		<div class="elementor-element elementor-element-ba1b762 gallery des e-flex e-con-boxed e-con e-parent" data-id="ba1b762" data-element_type="container">
					<div class="e-con-inner">
		<div class="elementor-element elementor-element-9c9686a e-con-full e-flex e-con e-child" data-id="9c9686a" data-element_type="container">
				<div class="elementor-element elementor-element-2631c9d elementor-widget elementor-widget-heading" data-id="2631c9d" data-element_type="widget" data-widget_type="heading.default">
				<div class="elementor-widget-container">
			<h1 class="elementor-heading-title elementor-size-default">Tourist Services</h1>		</div>
				</div>
				</div>
					</div>
				</div>
		<div class="elementor-element elementor-element-a9c6e3c gallery des e-flex e-con-boxed e-con e-parent" data-id="a9c6e3c" data-element_type="container">
					<div class="e-con-inner">
					    
					    
		                <?php 
		                echo $home['tourist1'];
		                echo $home['tourist1'];
		                echo $home['tourist1'];
		                ?>
				
				
				
					</div>
				</div>
		<div class="elementor-element elementor-element-ecc7b96 e-flex e-con-boxed e-con e-parent" data-id="ecc7b96" data-element_type="container">
					<div class="e-con-inner">
				<div class="elementor-element elementor-element-5c93667 elementor-widget elementor-widget-elementskit-button" data-id="5c93667" data-element_type="widget" data-widget_type="elementskit-button.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con" >		<div class="ekit-btn-wraper">
							<a href="<?php echo $url;   ?>tourist-service.php" class="elementskit-btn  whitespace--normal" id="">
					More Services				</a>
					</div>
        </div>		</div>
				</div>
					</div>
				</div>
				*/
				?>
				
				
				
				
				
				
				
				<section class="elementor-section elementor-top-section elementor-element elementor-element-85175a0 elementor-section-boxed elementor-section-height-default elementor-section-height-default" data-id="85175a0" data-element_type="section">
						<div class="elementor-container elementor-column-gap-no">
					<div class="elementor-column elementor-col-100 elementor-top-column elementor-element elementor-element-c82c0d8" data-id="c82c0d8" data-element_type="column">
			<div class="elementor-widget-wrap elementor-element-populated">
						<section class="elementor-section elementor-inner-section elementor-element elementor-element-ab905d1 elementor-section-boxed elementor-section-height-default elementor-section-height-default" data-id="ab905d1" data-element_type="section">
						<div class="elementor-container elementor-column-gap-no">
					<div class="elementor-column elementor-col-100 elementor-inner-column elementor-element elementor-element-05e3914" data-id="05e3914" data-element_type="column">
			<div class="elementor-widget-wrap elementor-element-populated">
						<div class="elementor-element elementor-element-2704413 elementor-widget elementor-widget-heading" data-id="2704413" data-element_type="widget" data-widget_type="heading.default">
				<div class="elementor-widget-container">
			<h2 class="elementor-heading-title elementor-size-default">Our Gallery</h2>		</div>
				</div>
					</div>
		</div>
					</div>
		</section>
		</div></div></div>
		</section>
		
		<section class="elementor-section elementor-top-section elementor-element elementor-element-85175a0 elementor-section-boxed elementor-section-height-default elementor-section-height-default" data-id="85175a0" data-element_type="section">
		
		<div class="elementor-element elementor-element-2fcb1f6 e-flex e-con-boxed e-con e-parent" data-id="2fcb1f6" data-element_type="container">
					<div class="e-con-inner">
				<div class="elementor-element elementor-element-89b325d elementor-widget elementor-widget-image-gallery" data-id="89b325d" data-element_type="widget" data-widget_type="image-gallery.default">
				<div class="elementor-widget-container">
			<style>/*! elementor - v3.22.0 - 26-06-2024 */
.elementor-image-gallery .gallery-item{display:inline-block;text-align:center;vertical-align:top;width:100%;max-width:100%;margin:0 auto}.elementor-image-gallery .gallery-item img{margin:0 auto}.elementor-image-gallery .gallery-item .gallery-caption{margin:0}.elementor-image-gallery figure img{display:block}.elementor-image-gallery figure figcaption{width:100%}.gallery-spacing-custom .elementor-image-gallery .gallery-icon{padding:0}@media (min-width:768px){.elementor-image-gallery .gallery-columns-2 .gallery-item{max-width:50%}.elementor-image-gallery .gallery-columns-3 .gallery-item{max-width:33.33%}.elementor-image-gallery .gallery-columns-4 .gallery-item{max-width:25%}.elementor-image-gallery .gallery-columns-5 .gallery-item{max-width:20%}.elementor-image-gallery .gallery-columns-6 .gallery-item{max-width:16.666%}.elementor-image-gallery .gallery-columns-7 .gallery-item{max-width:14.28%}.elementor-image-gallery .gallery-columns-8 .gallery-item{max-width:12.5%}.elementor-image-gallery .gallery-columns-9 .gallery-item{max-width:11.11%}.elementor-image-gallery .gallery-columns-10 .gallery-item{max-width:10%}}@media (min-width:480px) and (max-width:767px){.elementor-image-gallery .gallery.gallery-columns-2 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-3 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-4 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-5 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-6 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-7 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-8 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-9 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-10 .gallery-item{max-width:50%}}@media (max-width:479px){.elementor-image-gallery .gallery.gallery-columns-2 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-3 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-4 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-5 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-6 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-7 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-8 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-9 .gallery-item,.elementor-image-gallery .gallery.gallery-columns-10 .gallery-item{max-width:100%}}</style>		<div class="elementor-image-gallery">
			<div id='gallery-1' class='gallery galleryid-92 gallery-columns-4 gallery-size-full'>
			    <?php
			    
			    
			    
			    echo $home['gallery'];
			    
			    ?>
		</div>
		</div>
				</div>
				</div>
				<div class="elementor-element elementor-element-68f1a15 elementor-widget elementor-widget-elementskit-button" data-id="68f1a15" data-element_type="widget" data-widget_type="elementskit-button.default">
				<div class="elementor-widget-container">
			<div class="ekit-wid-con" >		<div class="ekit-btn-wraper">
							<a href="<?php echo $url;   ?>gallery.php" class="elementskit-btn  whitespace--normal" id="">
					More Gallery				</a>
					</div>
        </div>		</div>
				</div>
					</div>
				</div>
					</div>
		</div>
					</div>
					
					
					
				    
				    
					
		</section>
		<div class="elementor-element elementor-element-7e1c4f1 e-con-full e-flex e-con e-parent" data-id="7e1c4f1" data-element_type="container" style="margin:auto;">
				<div class="elementor-element elementor-element-fb1734d elementor-widget elementor-widget-html" data-id="fb1734d" data-element_type="widget" data-widget_type="html.default">
				<div class="elementor-widget-container">
			<div class="ads"></div>
		</div>
				</div>
				</div>
				</div>
			
	<footer id="colophon" class="site-footer site-footer-three has-footer-bg">
		<div class="site-footer-inner" style="background-image: url(">
							<div class="top-footer">
					<div class="wrap-footer-sidebar">
						<div class="container">
							<div class="footer-widget-wrap">
								<div class="row">
										<div class="col-sm-6 col-12 col-lg-4 footer-widget-item">
		<div id="block-9" class="widget widget_block"><div class="footer-item">
<div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">
<div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">
<h2 class="wp-block-heading"><?php echo $footerhead;    ?></h2>
</div></div>



    <?php echo $footer;   ?>


<p></p>
</div></div>
</div></div>			</div>
	<div class="col-sm-6 col-12 col-lg-4 footer-widget-item">
		<div id="block-11" class="widget widget_block"><div class="footer-item">
<div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">
<h2 class="wp-block-heading">Quick Links</h2>
</div></div>
</div></div><div id="nav_menu-2" class="widget widget_nav_menu"><div class="footer-item"><div class="menu-footer-widget-1-container"><ul id="menu-footer-widget-1" class="menu"><li id="menu-item-615" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-home current-menu-item page_item page-item-92 current_page_item menu-item-615">
    <a href="<?php echo $url;   ?>" aria-current="page">Home</a></li>
<li id="menu-item-616" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-616"><a href="<?php echo $url;   ?>about.php">About us</a></li>
<li id="menu-item-619" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-619"><a href="<?php echo $url;   ?>destination.php">Destination</a></li>
<li id="menu-item-617" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-617"><a href="<?php echo $url;   ?>food.php">Foods</a></li>
<li id="menu-item-617" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-617"><a href="<?php echo $url;   ?>festivals.php">Festivals</a></li>
<li id="menu-item-620" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-620"><a href="<?php echo $url;   ?>gallery.php">Gallery</a></li>
<li id="menu-item-618" class="menu-item menu-item-type-post_type menu-item-object-page menu-item-618"><a href="<?php echo $url;   ?>contact.php">Contact</a></li>
</ul></div></div></div>	</div>
	<div class="col-sm-6 col-12 col-lg-4 footer-widget-item">
		<div id="block-13" class="widget widget_block"><div class="footer-item">
<div class="wp-block-group"><div class="wp-block-group__inner-container is-layout-constrained wp-block-group-is-layout-constrained">
<h2 class="wp-block-heading">Contact Info</h2>



<p>Feel free to contact &amp; reach us..!!</p>



<p>Email : demo123@gmail.com</p>
</div></div>
</div></div>	</div>
								</div>
							</div>
						</div>
					</div>
				</div>
								</div>
	</footer><!-- #colophon -->
</div><!-- #page -->

			<script type='text/javascript'>
				const lazyloadRunObserver = () => {
					const lazyloadBackgrounds = document.querySelectorAll( `.e-con.e-parent:not(.e-lazyloaded)` );
					const lazyloadBackgroundObserver = new IntersectionObserver( ( entries ) => {
						entries.forEach( ( entry ) => {
							if ( entry.isIntersecting ) {
								let lazyloadBackground = entry.target;
								if( lazyloadBackground ) {
									lazyloadBackground.classList.add( 'e-lazyloaded' );
								}
								lazyloadBackgroundObserver.unobserve( entry.target );
							}
						});
					}, { rootMargin: '200px 0px 200px 0px' } );
					lazyloadBackgrounds.forEach( ( lazyloadBackground ) => {
						lazyloadBackgroundObserver.observe( lazyloadBackground );
					} );
				};
				const events = [
					'DOMContentLoaded',
					'elementor/lazyload/observe',
				];
				events.forEach( ( event ) => {
					document.addEventListener( event, lazyloadRunObserver );
				} );
			</script>
			<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-bosa-travel-tour-custom-woo1.0.min.js" id="wpo_min-footer-0-js"></script>
<script type="text/javascript" src="wp-includes/js/imagesloaded.min.js" id="imagesloaded-js"></script>
<script type="text/javascript" src="wp-includes/js/masonry.min.js" id="masonry-js"></script>
<script type="text/javascript" src="wp-includes/js/jquery/jquery.masonry.min.js" id="jquery-masonry-js"></script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/bootstrap/js/bootstrap.min.js" id="bootstrap-js"></script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/slick/slick.min.js" id="slick-js"></script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/js/jquery.slicknav.min.js" id="slicknav-js"></script>
<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-bosa-skip-link-focus-fix0.8.min.js" id="wpo_min-footer-7-js"></script>
<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-bosa-navigation0.8.min.js" id="wpo_min-footer-8-js"></script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/js/theia-sticky-sidebar.min.js" id="theia-sticky-sidebar-js"></script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/js/html5shiv.min.js" id="html5shiv-js"></script>
<script type="text/javascript" id="bosa-custom-js-extra">
/* <![CDATA[ */
var BOSA = {"is_rtl":"","is_admin_bar_showing":"","responsive_header_menu_text":"","header_image_slider":{"fade":true,"autoplay":0,"autoplaySpeed":4000,"fadeControl":500},"main_slider":{"fade":true,"autoplay":0,"autoplaySpeed":4000,"fadeControl":500},"home_highlight_posts":{"autoplay":0,"autoplaySpeed":4000,"slidesToShow":3},"fixed_nav":"1","mobile_fixed_nav_off":"","disable_scroll_top":"","sticky_sidebar":"1","header_two_logo":"","is_header_two":"1","is_frame_layout":"","fixed_header_logo":"1","separate_logo":"","is_front_page":"1","overlay_post":"","overlay_page":"","the_custom_logo":""};
/* ]]> */
</script>
<script type="text/javascript" src="wp-content/themes/bosa/assets/js/custom.min.js" id="bosa-custom-js"></script>
<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-elementskit-framework-js-frontend3.2.0.min.js" id="wpo_min-footer-12-js"></script>
<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-ekit-widget-scripts3.2.0.min.js" id="wpo_min-footer-13-js"></script>
<script type="text/javascript" src="wp-content/plugins/elementor/assets/js/webpack.runtime.min.js" id="elementor-webpack-runtime-js"></script>
<script type="text/javascript" src="wp-content/plugins/elementor/assets/js/frontend-modules.min.js" id="elementor-frontend-modules-js"></script>
<script type="text/javascript" src="wp-content/plugins/elementor/assets/lib/waypoints/waypoints.min.js" id="elementor-waypoints-js"></script>
<script type="text/javascript" src="wp-includes/js/jquery/ui/core.min.js" id="jquery-ui-core-js"></script>
<script type="text/javascript" id="elementor-frontend-js-before">
/* <![CDATA[ */
var elementorFrontendConfig = {"environmentMode":{"edit":false,"wpPreview":false,"isScriptDebug":false},"i18n":{"shareOnFacebook":"Share on Facebook","shareOnTwitter":"Share on Twitter","pinIt":"Pin it","download":"Download","downloadImage":"Download image","fullscreen":"Fullscreen","zoom":"Zoom","share":"Share","playVideo":"Play Video","previous":"Previous","next":"Next","close":"Close","a11yCarouselWrapperAriaLabel":"Carousel | Horizontal scrolling: Arrow Left & Right","a11yCarouselPrevSlideMessage":"Previous slide","a11yCarouselNextSlideMessage":"Next slide","a11yCarouselFirstSlideMessage":"This is the first slide","a11yCarouselLastSlideMessage":"This is the last slide","a11yCarouselPaginationBulletMessage":"Go to slide"},"is_rtl":false,"breakpoints":{"xs":0,"sm":480,"md":768,"lg":1025,"xl":1440,"xxl":1600},"responsive":{"breakpoints":{"mobile":{"label":"Mobile Portrait","value":767,"default_value":767,"direction":"max","is_enabled":true},"mobile_extra":{"label":"Mobile Landscape","value":880,"default_value":880,"direction":"max","is_enabled":false},"tablet":{"label":"Tablet Portrait","value":1024,"default_value":1024,"direction":"max","is_enabled":true},"tablet_extra":{"label":"Tablet Landscape","value":1200,"default_value":1200,"direction":"max","is_enabled":false},"laptop":{"label":"Laptop","value":1366,"default_value":1366,"direction":"max","is_enabled":false},"widescreen":{"label":"Widescreen","value":2400,"default_value":2400,"direction":"min","is_enabled":false}}},"version":"3.22.3","is_static":false,"experimentalFeatures":{"e_optimized_assets_loading":true,"e_optimized_css_loading":true,"e_font_icon_svg":true,"additional_custom_breakpoints":true,"container":true,"container_grid":true,"e_swiper_latest":true,"e_optimized_control_loading":true,"e_onboarding":true,"home_screen":true,"ai-layout":true,"e_lazyload":true},"urls":{"assets":"https:\/\/kedarnathdarshan.net\/wp-content\/plugins\/elementor\/assets\/"},"swiperClass":"swiper","settings":{"page":[],"editorPreferences":[]},"kit":{"active_breakpoints":["viewport_mobile","viewport_tablet"],"global_image_lightbox":"yes","lightbox_enable_counter":"yes","lightbox_enable_fullscreen":"yes","lightbox_enable_zoom":"yes","lightbox_enable_share":"yes","lightbox_title_src":"title","lightbox_description_src":"description"},"post":{"id":92,"title":"Kedarnath%20Darshan%20%7C%20A%20Divine%20Journey","excerpt":"","featuredImage":false}};
/* ]]> */
</script>
<script type="text/javascript" src="wp-content/plugins/elementor/assets/js/frontend.min.js" id="elementor-frontend-js"></script>
<script type="text/javascript" src="wp-content/plugins/elementskit-lite/widgets/init/assets/js/animate-circle.min.js" id="animate-circle-js"></script>
<script type="text/javascript" id="wpo_min-footer-20-js-extra">
/* <![CDATA[ */
var ekit_config = {"ajaxurl":"https:\/\/kedarnathdarshan.net\/wp-admin\/admin-ajax.php","nonce":"66c35663eb"};
/* ]]> */
</script>
<script type="text/javascript" src="wp-content/cache/wpo-minify/1724394010/assets/wpo-minify-footer-elementskit-elementor3.2.0.min.js" id="wpo_min-footer-20-js"></script>

<div id="back-to-top">
    <a href="javascript:void(0)"><i class="fa fa-angle-up"></i></a>
</div>
<!-- #back-to-top -->


<script>
var acc = document.getElementsByClassName("accordion");
var i;

for (i = 0; i < acc.length; i++) {
  acc[i].addEventListener("click", function() {
    this.classList.toggle("active");
    var panel = this.nextElementSibling;
    if (panel.style.maxHeight) {
      panel.style.maxHeight = null;
    } else {
      panel.style.maxHeight = panel.scrollHeight + "px";
    } 
  });
}
</script>




</body>


</html>


